#include<stdio.h>
#include<unistd.h>
#include<pthread.h>
#include<errno.h>
#include<signal.h>

void nothing(int sig) {
  printf("Do nothing\n");
}

struct data {
  int (*f)();
  int result;
  int finished;
  pthread_t parent;
};
  

call_f(struct data *my_data) {
 
  // pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
  printf("Empieza funcion\n");

  my_data->result = my_data->f();
  my_data->finished = 1;

  printf("Termina funcion\n");
  
  pthread_kill(my_data->parent,SIGUSR1);
  
}

int call_with_timeout(int (*f)(), int milisec) {
  pthread_t pid;
  struct data my_data;
  struct sigaction action;
  action.sa_handler = nothing;
  action.sa_flags = SA_RESTART;

  sigaction(SIGUSR1,&action,NULL);

  my_data.f = f;
  my_data.finished = 0;
  my_data.parent = pthread_self();

  
  pthread_create(&pid,NULL,(void *)call_f,&my_data);
  
  errno = 0;
  if(usleep(1000*milisec)) {
    if (errno == EINTR) {
      printf("Nos interrumpio la senal\n");
    }
  }

  if (my_data.finished) {
    return(my_data.result);
  } else {
    printf("TIMEOUT\n");
    pthread_cancel(pid);
    return(-1);
  }
}

int ls() {
  printf("Invoca ls\n");
  sleep(5);
  return(0);
}
 
main() {
    printf("llamando a ls con timeout (3 veces)\n");
    printf("debiera ser -1, retorna: %d\n", call_with_timeout(ls, 1000));
    printf("debiera ser 0, retorna: %d\n", call_with_timeout(ls, 10000));
    // printf("debiera ser -1, retorna: %d\n", call_with_timeout(ls, 1000));
 
}
