#include "tbox-cond.h"
#include <pthread.h>
#include <stdlib.h>

int getbox(box *buffer) {
  int indice,c;
  
  pthread_mutex_lock(&buffer->mutex);

  while (buffer->nllenos == 0)
    pthread_cond_wait(&buffer->llenos, &buffer->mutex);

  indice = buffer->out;
  buffer->out = (buffer->out + 1)%SIZE;
  c = buffer->val[indice];
  
  buffer->nllenos--;
  buffer->nvacios++;

  pthread_cond_signal(&buffer->vacios);
  pthread_mutex_unlock(&buffer->mutex);

  return(c);
}

void putbox(box *buffer, int value) {
  int indice;

  pthread_mutex_lock(&buffer->mutex);

  while (buffer->nvacios == 0)
    pthread_cond_wait(&buffer->vacios, &buffer->mutex);

  indice = buffer->in;
  buffer->in = (buffer->in + 1)%SIZE;
  
  buffer->val[indice] = value;

  buffer->nllenos++;
  buffer->nvacios--;

  pthread_cond_signal(&buffer->llenos);
  pthread_mutex_unlock(&buffer->mutex);
 
}

box *createbox() {
  box *result;
  result = (box *)malloc(sizeof(box));

  result->in = result->out = 0;
  result->nllenos = 0;
  result->nvacios = SIZE;

  pthread_mutex_init(&result->mutex,NULL);

  pthread_cond_init(&result->vacios,NULL);
  pthread_cond_init(&result->llenos,NULL);


  return(result);
}
