#include <stdio.h>
#include <pthread.h>

int fibonacci(int n){
    if (n == 0)
    	return 0;
    else if (n == 1)
        return 1;

    return fibonacci(n - 1) + fibonacci(n - 2);
}

void fib_thread(int* value){
	int *p = value;
	*p = fibonacci(*value);
}


/*
 * Multithreading version
 * */
void fib_multithread(int *value){
	int* p = value;
	//printf("thread trabajando con: %d\n", *value);

	if(*value == 0){
		*p = 0;
		return;
	} else if(*value == 1) {
		*p = 1;
		return;
	}

	int prev_1 = *value - 1;
	int prev_2 = *value - 2;

	pthread_t pid_1;
	pthread_t pid_2;

	pthread_create(&pid_1,NULL,(void *)fib_multithread, &prev_1);
	pthread_create(&pid_2,NULL,(void *)fib_multithread, &prev_2);

	pthread_join(pid_1, NULL);
	pthread_join(pid_2, NULL);

	*p = prev_1 + prev_2;
	return;
}


int main(){
	int value = 10;
	pthread_t pid;

	pthread_create(&pid, NULL, (void *)fib_thread, (void *)&value);
	pthread_join(pid, NULL);
	printf("resultado: %d \n",value);

	int value2 = 10;
	pthread_t pid2;
	pthread_create(&pid2, NULL, (void *)fib_multithread, (void *)&value2);
	pthread_join(pid2, NULL);
	printf("resultado paralelo: %d\n",value2);
	
	return 0;
}


