#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>

typedef struct limits {
  int desde;
  int hasta;
} LIMITS;

void fact(LIMITS *in) {
  int *result = (int *)malloc(sizeof(int));
  int i = 0;

  *result = 1;
  for (i=in->desde;i<=in->hasta;i++)
    *result = *result * i;

  printf("Este thread multiplica entre %d y %d = %d\n",in->desde,in->hasta,*result);
  pthread_exit(result);
}


int factorial_single(int n){
	pthread_t *pid = (pthread_t *)malloc(sizeof(pthread_t));
	LIMITS *lim = (LIMITS *)malloc(sizeof(LIMITS));
	int *result = (int *)malloc(sizeof(int));
	lim->desde = 1;
	lim->hasta = n;

	pthread_create(pid,NULL,(void *)fact,lim);
	pthread_join(*pid,(void **)&result);

	return *result;

}

int factorial_with_n(int n) {
	/*pthread_t es un int que almacena los ID de los threads para poder recuperarlos*/

	/*pido memoria para almacenar los PID, los limites de cada thread y el resultado*/
	pthread_t *pids = (pthread_t *)malloc(sizeof(pthread_t)*2);
	LIMITS *lim = (LIMITS *)malloc(sizeof(LIMITS)*2);
	int *aux_result = (int *)malloc(sizeof(int));

	pthread_t *pids_aux = pids;

	int result = 1;
	int i = 0;
//	DA *values = (DA *)malloc(sizeof(DA)*2);


	lim->desde = 1;
	lim->hasta = n/2;
	/*incrementamos lim para pasarlo al proximo create*/
	pthread_create(pids_aux++,NULL,(void *)fact,lim++);

	lim->desde = n/2+1;
	lim->hasta = n;
	pthread_create(pids_aux,NULL,(void *)fact,lim);

	pids_aux = pids;

	for(i=0;i<2;i++){
		pthread_join(*(pids_aux++),(void **)&aux_result);
		result = result * (*aux_result);
	}

  return(result);
}

int main() {
  printf("Valor %d\n",factorial_with_n(10));
  printf("Valor %d\n", factorial_single(10));
  return 0;
}
