#include "tbox.h"
#include <pthread.h>
#include <stdlib.h>


int getbox(box *buffer) {
  pthread_mutex_lock(&buffer->puedo_sacar);

  int c = buffer->val[buffer->out];
  buffer->out  = (buffer->out+1)%SIZE;

  if (buffer->in != buffer->out)
      pthread_mutex_unlock(&buffer->puedo_sacar);

  pthread_mutex_unlock(&buffer->puedo_poner);
  return(c);
}

void putbox(box *buffer, int value) {
  pthread_mutex_lock(&buffer->puedo_poner);

  buffer->val[buffer->in] = value;
  buffer->in = (buffer->in + 1)%SIZE;
  
  if (buffer->in != buffer->out)
      pthread_mutex_unlock(&buffer->puedo_poner);


  pthread_mutex_unlock(&buffer->puedo_sacar);
}

box *createbox() {
  box *result;
  result = (box *)malloc(sizeof(box));

  result->in = result->out = 0;

  pthread_mutex_init(&result->puedo_sacar,NULL);
  pthread_mutex_init(&result->puedo_poner,NULL);

  pthread_mutex_lock(&result->puedo_sacar);

  return(result);
}
