#include "tbox-sem.h"
#include <pthread.h>
#include <stdlib.h>


int getbox(box *buffer) {
  int indice,c;
  sem_wait(&buffer->puedo_sacar);
  
  pthread_mutex_lock(&buffer->sacar);
  indice = buffer->out;
  buffer->out = (buffer->out + 1)%SIZE;
  pthread_mutex_unlock(&buffer->sacar);

  c = buffer->val[indice];
 
  sem_post(&buffer->puedo_poner);

  return(c);
}

void putbox(box *buffer, int value) {
  int indice;
  sem_wait(&buffer->puedo_poner);
  
  pthread_mutex_lock(&buffer->poner);
  indice = buffer->in;
  buffer->in = (buffer->in + 1)%SIZE;
  pthread_mutex_unlock(&buffer->poner);
  
  buffer->val[indice] = value;
 
  sem_post(&buffer->puedo_sacar);
}

box *createbox() {
  box *result;
  result = (box *)malloc(sizeof(box));

  result->in = result->out = 0;

  sem_init(&result->puedo_poner,0,SIZE);
  sem_init(&result->puedo_sacar,0,0);

  pthread_mutex_init(&result->sacar,NULL);
  pthread_mutex_init(&result->poner,NULL);

  return(result);
}
