#include<stdio.h>
#include<pthread.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "tbox-sem.h"

box *buffer;

void prod(int *id) {
  printf("Nace productor %d\n",*id);

  while(1) {
    putbox(buffer,*id);
    printf("%d Puse: %d\n",*id,*id);
    sleep(1);
  }
}

void cons(int *id) {
  int c;
  
  printf("Nace consumidor %d\n",*id);

  while(1) {
    c = getbox(buffer);
    printf("%d Obtuvo: %d\n",*id,c);
    sleep(1);
  }
}

void print_usage(char *name) {

  printf("Use %s <consumidores> <productores>\n",name);
  exit(1);
}

int main(int argc, char *argv[]) {
  pthread_t *pids;
  int ncons, nprod;
  int *pprod, *pcons;
  int i;

 
  if (argc != 3)
    print_usage(argv[0]);

  errno = 0;
  ncons = strtoul(argv[1],NULL,10);
  if (errno != 0) {
    printf("No pude convertir a entero los consumidores\n");
    exit(-1);
  }

  errno = 0;
  nprod = strtoul(argv[2],NULL,10);
  if (errno != 0) {
    printf("No pude convertir a entero los productores\n");
    exit(-1);
  }

  printf("Ejecutando con %d consumidores y %d productores\n",ncons,nprod);

  buffer = createbox();

  pids = (pthread_t *)malloc(sizeof(pthread_t)*(ncons+nprod));
  pprod = (int *)malloc(sizeof(int)*nprod);
  pcons = (int *)malloc(sizeof(int)*ncons);

  for (i=0;i<ncons;i++) {
    pcons[i] = i;
    pthread_create(&pids[i],NULL,(void *)cons,&pcons[i]);
  }

  for (i=0;i<nprod;i++) {
    pprod[i] = i;
    pthread_create(&pids[ncons+i],NULL,(void *)prod,&pprod[i]);
  }

  for (i=0;i<nprod+ncons;i++)
    pthread_join(pids[i],NULL);

}
