#include "tbox.h"
#include <pthread.h>
#include <stdlib.h>


int getbox(box *buffer) {
  pthread_mutex_lock(&buffer->lleno);
  int c = buffer->val;
  pthread_mutex_unlock(&buffer->vacio);
  return(c);
}

void putbox(box *buffer, int value) {
  pthread_mutex_lock(&buffer->vacio);
  buffer->val = value;
  pthread_mutex_unlock(&buffer->lleno);
}

box *createbox() {
  box *result;
  result = (box *)malloc(sizeof(box));

  pthread_mutex_init(&result->vacio,NULL);
  pthread_mutex_init(&result->lleno,NULL);

  pthread_mutex_lock(&result->lleno);

  return(result);
}
