#include<stdio.h>
#include<stdlib.h>

typedef struct node {
  int value;
  struct node *next;
} node;

typedef struct dic {
  char *key;
  char *value;
  struct dic *next;
} dic;

/*
void insert_end_I(node **l, int val) {
  node *aux;

  if (*l == NULL) {
    *l = (node *)malloc(sizeof(node));
    (*l)->value = val;
    (*l)->next = NULL;
  return;
  // Y que hago con l ?
  }
  
  while ((*l)->next != NULL)
    *l = (*l)->next;

  aux = (node *)malloc(sizeof(node));
  aux->value = val;
  aux->next = NULL;
  (*l)->next = aux;
}

node *insert_end_II(node *l, int val) {
  node *aux, *first;

  if (l == NULL) {
    l = (node *)malloc(sizeof(node));
    l->value = val;
    l->next = NULL;
    return l;
  }
  
  first = l;
  while (l->next != NULL)
    l = l->next;

  aux = (node *)malloc(sizeof(node));
  aux->value = val;
  aux->next = NULL;
  l->next = aux;
  return(first);
}

void print_listIyII(node *l) {
  if (l == NULL) {
    printf("\n");
    return;
  }

  printf("%d -> ",l->value);
  print_list(l->next);

}
*/

node *create_list() {
  node *result;

  result = (node *)malloc(sizeof(node));
  result->next = NULL;
  return(result);
}

void insert_end(node *l, int val) {
  node *aux;

  if (l == NULL) 
    return;

  while (l->next != NULL)
    l = l->next;

  aux = create_list();
  aux->value = val;
  l->next = aux;
}

void insert_order_asc(node *l, int val) {
  node *aux;

  if (l == NULL) 
    return;

  while (l->next != NULL && l->next->value < val)
    l = l->next;

  aux = create_list();
  aux->value = val;
  
  aux->next = l->next;
  l->next = aux;

}

void print_list(node *l) {
  if (l == NULL) 
    return;
  
  while ((l = l->next) != NULL)
    printf("%d -> ",l->value);

  printf("//\n");

}

void free_list(node *l) {
  if (l == NULL)
    return;

  free_list(l->next);
  free(l);

}


int main(int argc, char *argv[]) {
  node *lista = NULL;

  lista = create_list();
  insert_end(lista, 3);
  insert_end(lista, 5);
  print_list(lista);

  free_list(lista);
  lista = NULL;

  lista = create_list();
  insert_order_asc(lista, 3);
  insert_order_asc(lista, 5);
  insert_order_asc(lista, 1);
  insert_order_asc(lista, 11);
  insert_order_asc(lista, 32);
  insert_order_asc(lista, 19);
  print_list(lista);

  free_list(lista);
  lista = NULL;



  /*
  insert_end_I(&lista, 3);
  insert_end_I(&lista, 5);
  print_list(lista);

  node *lista2 = NULL;

  lista2 = insert_end_II(lista2, 3);
  lista2 = insert_end_II(lista2, 5);
  print_list(lista2);
  insert_end_II(lista2, 8);
  print_list(lista2);
  */


}


