#include <stdlib.h>
#include <stdio.h>

typedef struct {
	char element;
	struct nodo* next;
} Nodo;

typedef struct {
	Nodo* frente;
	Nodo* final;
} Queue;

/*Prototipos de funciones*/
void crearCola(Queue *q);
void insertar(Queue *q, char e);
char quitar(Queue *q);
void borrarCola(Queue *q);
char frente(Queue q);
int colaVacia(Queue q);


void crearCola(Queue *q) {
	q->frente = NULL;
	q->final = NULL;
}

Nodo* crearNodo(char e) {
	Nodo* t;
	t = (Nodo *)malloc(sizeof(Nodo));
	t->element = e;
	t->next = NULL;
	return t;
}

int colaVacia(Queue q) {
	return (q.frente == NULL);
}

void insertar(Queue* q, char e) {
	Nodo* temp;
	temp = crearNodo(e);
	
	if(colaVacia(*q))
		q->frente = temp;
	else
		q->final = temp;
}

char quitar(Queue* q){
	char temp;
	if(!colaVacia(*q)){
		Nodo* a;
		a=q->frente;
		temp = q->frente->element;
		q->frente = q->frente->next;
		free(a);
	}
	else
		fprintf(stderr, "Problema al eliminar");
	return temp;
}


char frente(Queue q) {
	if(!colaVacia(q))
		return (q.frente -> element);
}

void borrarCola(Queue *q) {
	for(;q->frente != NULL;) {
		Nodo *n;
		n = q->frente;
		q->frente = q->frente->next;
		free(n);
	}
}

int main(){
	
	/*Aca implementar cola*/
	return 0;
}

	
	
	
	
		