#include <stdio.h>
#include <stdlib.h>

typedef struct nodo {
	char val;
	struct nodo *next;
} stack;


stack *create_stack() {
	stack *res = (stack *)malloc(sizeof(stack));
	res->next = NULL;
}


int is_empty(stack *st) {
	if (st == NULL || st->next == NULL)
		return(1);
	return(0);
}

void free_stack(stack *st) {
	if (st == NULL) return;
	free_stack(st->next);
	free(st);
}

void put(stack *st, char val) {
	stack *res = (stack *)malloc(sizeof(stack));
	res->val = val;
	res->next = st->next;
	st->next = res;
}

char get(stack *st) {
	stack *aux = NULL;
	if (st == NULL || st->next == NULL) 
		return(EOF);
	
	char res = st->next->val;
	aux = st->next;
	st->next = st->next->next;
	free(aux);
	return res;
}

int main(int argc, char *argv[]) {
	stack *st;
	char c;
	int non = 0;
	
	st = create_stack();
	
	while ((c = getchar()) != EOF && !non) {
		/*print_stack(st);*/
		switch (c) {
			case '(': 
				put(st,c); 
				break;
			case '{': 
				put(st,c); 
				break;
			case '[': 
				put(st,c); 
				break;
			case ')': 
				if (get(st) != '(')
					non = 1;
				break;
			case '}': 
				if (get(st) != '{')
					non = 1;
				break;
			case ']': 
				if (get(st) != '[')
					non = 1;
				break;
			default: ;
		}
	}
	
	if (!is_empty(st) || non)
		printf("La entrada no tiene los parentesis balanceados\n");
	else
		printf("La entrada tiene los parentesis balanceados\n");
	
	free_stack(st);
	return 0;
}


