package views;

import controllers.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import java.util.Observer;
import javax.swing.*;
import models.Counter;

/**
 * @author fespinoza
 */
public class CounterView extends JFrame implements Observer {

    public JLabel message;
    public JLabel value;
    public JButton reset;
    public JButton plus;
    public JButton minus;
    public Counter counter;

    public CounterView() {
        this(new Counter());
    }

    public CounterView(Counter counter) {
        super("Counter App");

        this.counter = counter;
        counter.addObserver(this);

        this.setLayout(new GridLayout(2,1));
        this.add(makeViewers());
        this.add(makeControls());

        this.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                CounterView.this.dispose();
            }
        });
        this.pack();
    }

    public Counter getCounter() {
        return this.counter;
    }

    public void update(Observable o, Object o1) {
        updateValue();
    }

    private Component makeControls() {
        JPanel p = new JPanel();
        this.setLayout(new FlowLayout());

        plus = new JButton("  +  ");
        minus = new JButton("  -  ");
        reset = new JButton("reset");

        p.add(plus);
        p.add(minus);
        p.add(reset);

        plus.addActionListener(new PlusListener(this));
        minus.addActionListener(new MinusListener(this));
        reset.addActionListener(new ResetListener(this));

        return p;
    }

    private Component makeViewers() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());

        message = new JLabel("Counter:");
        value = new JLabel(counter.getCount() + "");
        p.add(message);
        p.add(value);

        return p;
    }

    private void updateValue() {
        value.setText(counter.getCount() + "");
    }
}
