#include <QtGui>
#include "renderarea.h"
#include "window.h"

Window::Window()
{
    renderArea = new RenderArea;

    shapeComboBox = new QComboBox;
    shapeComboBox->addItem(tr("Polygon"),0);
    shapeComboBox->addItem(tr("Rectangle"),1);
    shapeComboBox->addItem(tr("Ellipse"),2);
    shapeComboBox->addItem(tr("Line"),3);
    shapeComboBox->addItem(tr("Polyline"),4);
    shapeComboBox->addItem(tr("Points"),5);

    shapeLabel = new QLabel("Shape:");

    pushButton = new QPushButton("Dibujar");

    connect(pushButton, SIGNAL(clicked()), this, SLOT(button_clicked()));

    QGridLayout *mainLayout = new QGridLayout;

    mainLayout->addWidget(renderArea, 0, 0, 1, 4);
    mainLayout->addWidget(shapeLabel, 2, 1, Qt::AlignRight);
    mainLayout->addWidget(shapeComboBox, 2, 2);
    mainLayout->addWidget(pushButton, 3, 2);
    setLayout(mainLayout);

    setWindowTitle(tr("Ejemplo1: CC3002 - Qt y C++"));
}

void Window::button_clicked()
{
    renderArea->shape = shapeComboBox->currentIndex();
    renderArea->update();
}
