#include <QtGui>
#include "renderarea.h"

RenderArea::RenderArea(QWidget *parent)
    : QWidget(parent)
{
    setBackgroundRole(QPalette::Base);
    setAutoFillBackground(true);
}

QSize RenderArea::sizeHint() const
{
    return QSize(400, 200);
}

void RenderArea::paintEvent(QPaintEvent * )
{
    QPoint points[4] = {
        QPoint(10, 80),
        QPoint(20, 10),
        QPoint(80, 30),
        QPoint(90, 70)
    };

    QRect rect(10, 20, 80, 60);

    QPainter painter(this);

    for (int x = 0; x < width(); x += 100) {
        for (int y = 0; y < height(); y += 100) {
            painter.save();
            painter.translate(x, y);
            switch (shape) {
            case 0: //Polygon
                painter.setPen(Qt::red);
                painter.setBrush(Qt::gray);
                painter.drawPolygon(points, 4);
                break;
            case 1: //Rect
                painter.setPen(Qt::blue);
                painter.setBrush(Qt::yellow);
                painter.drawRect(rect);
                break;
            case 2: //Ellipse
                painter.setPen(Qt::blue);
                painter.setBrush(Qt::green);
                painter.drawEllipse(rect);
                break;
            case 3: //Line
                painter.setPen(Qt::red);
                painter.drawLine(rect.bottomLeft(), rect.topRight());
                break;
            case 4: //Polyline
                painter.setPen(Qt::black);
                painter.drawPolyline(points, 4);
                break;
            case 5: //Points
                painter.setPen(Qt::red);
                painter.drawPoints(points, 4);
                break;
            }
            painter.restore();
        }
    }

    painter.setPen(Qt::black);
    painter.setBrush(Qt::NoBrush);
    painter.drawRect(QRect(0, 0, width() - 1, height() - 1)); //dibuja el borde del area de dibujo
}
