
#include <assert.h>


template<class T> 
class stack{

     public:
	stack();
	stack(int);
        stack(stack<T>& s);
	~stack();
	
	void push(T elemento);
	void pop();

	T top();
	int empty(); 

     private:
	T* contenedor;
	int tamano;
	int tope;
	
	int operator==(stack<T>& s);
	int invariante(){ 
	    return tamano > 0 && tope >=-1 && tope < tamano && contenedor != NULL;
	}
};


	
template<class T> stack<T>::stack(){
	assert(0);
}

template<class T> stack<T>::stack(int t){
	assert(t>0);

	tamano = t;	
	tope = -1;
	contenedor = new T[t];

	assert(invariante());
}

template<class T> stack<T>::stack(stack<T>& s){
	assert(s.invariante());

	tamano = s.tamano;
	tope = s.tope;
	contenedor = new T[s.tamano];

        for(int i=0; i<=tope; i++)
		 contenedor[i] = s.contenedor[i];

	assert(invariante() && s.invariante() && s == *this);
}

template<class T> stack<T>::~stack(){
	assert(invariante());

        delete contenedor;
}


template<class T> void stack<T>::push(T elemento){
	assert(invariante() && (tope+1) < tamano);

	contenedor[tope+1] = elemento;
	tope +=1;

	assert(contenedor[tope] == elemento && 
	       invariante());

}

template<class T> void stack<T>::pop(){
	assert( !empty() && invariante());

	tope -=1;

	assert(invariante());
	
}

template<class T> int stack<T>::empty(){
	assert(invariante());

	return tope == -1;

}

template<class T> T stack<T>::top(){
	assert( !empty() && invariante());

	return contenedor[tope];

}


template<class T> int stack<T>::operator==(stack<T>& s){
	assert( invariante() || s.invariante() );

	/* solo el contenido debe der igual */
	if( tope != s.tope ) return 0; 

	int i;
	for(i=0; i <= tope;  i++ )
	    if( contenedor[i] != s.contenedor[i]) return 0;


	return 1;
}
