#!/usr/bin/env python
# encoding: utf-8

from mpl_toolkits.mplot3d import Axes3D
from matplotlib import cm
from scipy import signal

import matplotlib.pyplot as plt
import numpy as np
import pylab as pl

def rect2d(Ny,Nx,R):

    my_matrix =  np.zeros((Ny,Nx))
    center_y  = int(Ny)/2
    center_x  = int(Nx)/2
    for x in range(Nx):
        for y in range(Ny):
            dist = ((y-center_y)**2 + (x-center_x)**2)**0.5
            if dist <= R: my_matrix[y][x] = 1
    return my_matrix

def graficar1(X,Y,signal1,title1):

    fig = plt.figure()

    ax = fig.gca(projection='3d')
    ax.set_title(title1)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal1.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    plt.show()

def graficar2(X,Y,signal1,signal2,title1,title2):

    fig = plt.figure(figsize=plt.figaspect(0.5))

    ax = fig.add_subplot(1, 2, 1, projection='3d')
    ax.set_title(title1)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal1.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    ax = fig.add_subplot(1, 2, 2, projection='3d')
    ax.set_title(title2)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal2.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    plt.show()

def graficar4(X,Y,signal1,signal2,signal3,signal4,title1,title2,title3,title4):

    fig = plt.figure(figsize=plt.figaspect(0.5))

    ax = fig.add_subplot(2, 2, 1, projection='3d')
    ax.set_title(title1)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal1.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    ax = fig.add_subplot(2, 2, 2, projection='3d')
    ax.set_title(title2)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal2.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    ax = fig.add_subplot(2, 2, 3, projection='3d')
    ax.set_title(title3)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal3.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    ax = fig.add_subplot(2, 2, 4, projection='3d')
    ax.set_title(title4)
    ax.set_xlabel('X'); ax.set_ylabel('Y'); ax.set_zlabel('Z')
    surf = ax.plot_surface(X, Y, signal4.real, rstride=1, cstride=1, cmap=cm.jet, linewidth=0, antialiased=False)
    fig.colorbar(surf, shrink=0.5, aspect=10)

    plt.show()

def gaussian(height, center_x, center_y, width_x, width_y):

    width_x = float(width_x)
    width_y = float(width_y)
    return lambda x,y: height*np.exp(-(((center_x-x)/width_x)**2+((center_y-y)/width_y)**2)/2)

min_x = -100
max_x =  100
min_y = -100
max_y =  100
delta =  1

Nx = (max_x - min_x)/delta
Ny = (max_y - min_y)/delta

X,Y = pl.mgrid[min_x:max_x:delta, min_y:max_y:delta]

# La señal son 3 gaussianas + ruido
my_signal =  np.zeros((Ny,Nx))
my_signal += gaussian(1.0, -30,  20, 20, 20)(X,Y)
my_signal += gaussian(0.7,  50,   0, 25, 50)(X,Y)
my_signal += gaussian(0.4, -50, -50, 30, 30)(X,Y)

# Agregamos ruido.
my_signal_n = my_signal + np.random.standard_normal((Ny,Nx)) * 0.1

# Graficamos las señales
graficar2(X,Y,my_signal,my_signal_n,'Original Signal','Noisy Signal')

# PRIMERA FORMA: MULTIPLICACION EN ESPACIO DE FOURIER
# cleaned_signal = IFFT2( FFT2(my_signal_n) * rectangulo2D )

# Calculamos la FFT2 de la señal
FFT2_my_signal   =np.fft.fftshift(np.fft.fft2 (my_signal))
FFT2_my_signal_n = np.fft.fftshift(np.fft.fft2 (my_signal_n))

# Graficamos la FFT2 de la señal original y la señal ruidosa
graficar2(X,Y,FFT2_my_signal,FFT2_my_signal_n,'FFT2: Original Signal','FFT2: Noisy Signal')

# Cortamos las frecuencias altas y graficamos
rect = rect2d(Ny,Nx,20)
FFT2_cleaned = FFT2_my_signal_n*rect
cleaned_signal = np.fft.ifft2(np.fft.ifftshift(FFT2_cleaned))
graficar2(X,Y,my_signal, cleaned_signal,'Original Signal','Cleaned Signal (with FFT2)')

# SEGUNDA FORMA: CONVOLUCION EN ESPACIO TEMPORAL (O DE COORDENADAS)
# cleaned_signal = Convolve2d( my_signal_n , filtro_sinc )

# Graficamos el filtro obtenido con la IFFT2 sobre el rectángulo-2d
filtro_sinc = np.fft.fftshift(np.fft.ifft2(np.fft.ifftshift(rect)))
graficar1(X,Y,filtro_sinc,'Filtro: Funcion Sinc = IFFT2(rectangle-2d)')

# Hacemos la convolucion-2d y graficamos
cleaned_signal_conv = signal.convolve2d( my_signal_n , filtro_sinc , mode='same')
graficar2(X,Y,my_signal,cleaned_signal_conv,'Original Signal','Cleaned Signal (with Convolution)')

# Ahora graficamos todo para comparar
graficar4(X,Y,my_signal,my_signal_n,cleaned_signal,cleaned_signal_conv,'Original Signal','Noisy Signal','Cleaned Signal (with FFT2)','Cleaned Signal (with Convolution)')
