package source;
import java.awt.*;
import java.net.URL;


/*Present a simple graphic to the user upon launch of the application, to 
* provide a faster initial response than is possible with the main window.
* 
* <P>Adapted from an 
* <a href=http://developer.java.sun.com/developer/qow/archive/24/index.html>item</a> 
* on Sun's Java Developer Connection.
*
* 
* @used.By {@link stocksmonitor.Launcher}
* @author <a href="http://www.javapractices.com/">javapractices.com</a>
*/


final class SplashScreen extends Frame
{
public SplashScreen(String aImageId)
{
if ( aImageId == null || aImageId.trim().length() == 0 ){
throw new IllegalArgumentException("Image Id does not have content.");
}
fImageId = aImageId;
}
public void splash()
{
initImageAndTracker();
setSize(fImage.getWidth(null), fImage.getHeight(null));
center();
fMediaTracker.addImage(fImage, 0);
try {
fMediaTracker.waitForID(0);
}
catch(InterruptedException ie){
System.out.println("Cannot track image load.");
}
SplashWindow splashWindow = new SplashWindow(this,fImage);
}
public final String fImageId;
public MediaTracker fMediaTracker;
public Image fImage; 
public void initImageAndTracker()
{
fMediaTracker = new MediaTracker(this);
URL imageURL = SplashScreen.class.getResource(fImageId);
fImage = Toolkit.getDefaultToolkit().getImage(imageURL);
}
public void center()
{
Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
Rectangle frame = getBounds();
setLocation((screen.width - frame.width)/2, (screen.height - frame.height)/2);
}
public static void show(String[] args)
{
SplashScreen splashScreen = new SplashScreen("SolarSplash.gif");
splashScreen.splash();
try {
Thread.sleep(2000);

splashScreen.dispose();
}
catch(InterruptedException ex) {
System.out.println(ex);
}
}
}
