package source;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.*;

import com.jgoodies.forms.builder.*;
import com.jgoodies.forms.layout.FormLayout;

public class LatLongGUI {

    public static boolean Latlon = false;
	static String _lat="", _lon="", _yr="", _elev="";
	
	static JTextField lat;
    static JTextField lon;
    static JTextField elev;
    static JTextField yr;
    static JLabel city;
    JButton btn_c = new JButton("Completed");
    JButton btn_hlp = new JButton ("Help");
    JButton btn_exit = new JButton ("Exit");
    
    private JButton  b_zip;
    
    

    public static void main(String[] args) {
       
        JFrame frame = new JFrame();
        frame.setTitle("Site Selection");
        frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        JComponent panel = new LatLongGUI().buildPanel();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
        
        
    }

    // Component Creation and Initialization **********************************

    /**
     *  Creates and intializes the UI components.
     */
    private void initComponents() {
     
    	lat       = new JTextField();
        lon        = new JTextField();
         city = new JLabel(" ");
        
        elev      = new JTextField();
        yr        = new JTextField();
        b_zip 	= new JButton ("Search US Zip Code");
        
        btn_c.addActionListener(new Completed());
        btn_hlp.addActionListener(new HelpDialog());
        btn_exit.addActionListener(new PrgExit());
        
    }

    // Building *************************************************************

    /**
     * Builds the pane.
     * 
     * @return the built panel
     */
   
    public JComponent buildPanel() {
        initComponents();
        
        FormLayout layout = new FormLayout(
                "right:max(40dlu;pref), 3dlu, 70dlu, 7dlu, "
              + "right:max(40dlu;pref),",//  3dlu, 70dlu",
                "p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, "
              + "p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, "
              + "p, 3dlu, p, 3dlu, p, 3dlu, p");

        PanelBuilder builder = new PanelBuilder(layout);
      
        
        builder.setDefaultDialogBorder();

        builder.addSeparator("Enter Location");
        builder.nextLine(2);

        builder.addLabel("Latitude");         builder.nextColumn(2);
        builder.add(lat);
        builder.nextLine(2);

        builder.add(city);           builder.nextColumn(2);
                          builder.nextColumn(2);    builder.add(b_zip);
                
        b_zip.addActionListener(new zipcodesearch());
        
        builder.nextLine(2);

        builder.addLabel("Longitude");           builder.nextColumn(2);
        builder.add(lon);
        builder.nextLine(2);

        builder.addSeparator("Other Parameters");
        builder.nextLine(2);

        builder.addLabel("Elevation (in meters)");            builder.nextColumn(2);
        builder.add(elev);
        builder.nextLine(8);
        builder.addLabel("Year");            builder.nextColumn(2);
        builder.add(yr);
        builder.nextLine(2);
        builder.nextColumn(2);
        
        builder.add(btn_c);  builder.nextColumn(2);builder.add(btn_hlp);
        
        
       
        
        
       
        
        

       
                return builder.getPanel();
    }

    class Completed implements ActionListener {
        public void actionPerformed(ActionEvent e) {
              
        	  _lat	= lat.getText();
              _lon 	= lon.getText();
              _yr 	= yr.getText();
              _elev = elev.getText();
          
              
              
              
              if ( _lat.equals("") || _lat.equals("") || _yr.equals("") || _elev.equals(""))
              {
            	  
            	  JOptionPane.showMessageDialog(null, "Please enter all the required site data.", "Error", 0);
            	  
              }
              else
            	  {
            	System.out.println("completed... ");
            	System.out.println("lat:"+_lat+":");
            	System.out.println("lon:"+_lon+":");
            	System.out.println("yr:"+_yr+":");
            	System.out.println("elev:"+_elev+":");
            	
            	LatLongGUI.Latlon = true;
            	  }
              
            
           
            
            
        }
    }


    class HelpDialog implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        	        	
        URL index = ClassLoader.getSystemResource("helpfile/index.html");    	
        // display help dialog... 
        new HelpWindow("SolarCalc Help Screen", index);

    }


}


 class PrgExit implements ActionListener {
    public void actionPerformed(ActionEvent e) {
        
    	
        // Exits Program
    	
    	
    	System.exit(0);
    	
}
    
}
}

 
 