from Tkinter import *
import math

class DibujaFuncion:

	def __init__(self, ventana, funcion, n, a, b, W, H):
		self.ventana = ventana
		self.cv=Canvas(self.ventana,width=W,height=H,
			       bg="white")
		self.cv.pack()
		self.graficar(funcion,n,a,b,self.cv,W,H)

	def graficar(self,f,n,a,b,cv,W,H):
		minimo=f(a)
		maximo=f(a)
		delta=(b-a)/(n-1)
		x=a+delta
		while x <= b:
			y=f(x)
			minimo=min(y,minimo)
			maximo=max(y,maximo)
			x = x + delta

		h0=0
		v0=H-self.coordenadaPixel(f(a),minimo,maximo,H)
		x = a + delta
		while x <= b:
			h=self.coordenadaPixel(x,a,b,W)
			v=H-self.coordenadaPixel(f(x),minimo,maximo,H)
			cv.create_line(h0,v0,h,v)
			h0=h; v0=v
			x=x+delta

	# cambio de coordenadas de [y,z] a [0,W]
	# x-y es a x'-0
	# z-y es a W-0
	# => x' = x * (x-y) / (z-y)
	def coordenadaPixel(self,x,y,z,w):
		return int(w*(x-y)/(z-y)+0.5)

def cuadrado(x): return x*x
	
# main
v1 = Tk()
i1 = DibujaFuncion(v1, math.sin,20,0,2*math.pi,200,100)
v1.mainloop()


v2 = Tk()
i2 = DibujaFuncion(v2, cuadrado,20,-100,100,200,200)
v2.mainloop()

