import math
class Tortuga:
	
	def __init__(self,h,v,a,cv):
		self.h = h
		self.v = v
		self.angulo = a
		self.cv = cv
		self.pintar()
	
	def pintar(self):
		self.cuerpo = self.cv.create_oval(self.h-10,self.v-10,self.h+10,self.v+10)
		self.cabeza = self.cv.create_oval(self.h+int(13*math.cos(self.angulo))-3,self.v+int(-13*math.sin(self.angulo))-3,self.h+int(13*math.cos(self.angulo))+3,self.v+int(-13*math.sin(self.angulo))+3)	
		
	def girar(self,ang):
		self.cv.delete(self.cuerpo)
		self.cv.delete(self.cabeza)
		self.angulo += ang*math.pi/180
		self.pintar()
		
	
	def avanzar(self,d):
		h1 = self.h + d*math.cos(self.angulo)
		v1 = self.v - d*math.sin(self.angulo)
		self.cv.create_line(self.h,self.v,h1,v1)
		self.cv.delete(self.cuerpo)
		self.cv.delete(self.cabeza)
		self.h = h1
		self.v = v1
		self.pintar()
	
	def mover(self,h,v):
		self.cv.delete(self.cuerpo)
		self.cv.delete(self.cabeza)
		self.h = h
		self.v = v
		self.pintar()
	
