// - Copyright Notice
// -----------------------------------------------------------------------
// (C) Copyright 1998 Fuego Inc.  All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Fuego Inc.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// $Id: JavaCILBaseParser.g 98820 2009-06-04 14:06:28Z diegor $
// -----------------------------------------------------------------------

header {
    package oracle.bpm.compiler.langs.java;
}

options {
    mangleLiteralPrefix="";
    upperCaseMangledLiterals=true;
}


// Import the necessary classes
{
    import oracle.bpm.type.Argument;
    import fuego.parser.MismatchedTokenException;
    import oracle.bpm.compiler.*;
}

class JavaCILBaseParser
    extends FuegoBaseParser;

options {
    importVocab=Java;
}

tokens {
    COMPLETION<AST=Completion>;
    ADD<AST=Term.Add>;
    SUB<AST=Term.Sub>;
    MUL<AST=Arithmetic.Mul>;
    DIV<AST=Arithmetic.Div>;
    REM<AST=Arithmetic.Rem>;
    INC<AST=IncDecOperator.PreInc>;
    DEC<AST=IncDecOperator.PreDec>;
    NOT<AST=Not>;
    AND<AST=Logic.And>;
    OR <AST=Logic.Or>;
    XOR<AST=Logic.Xor>;
    NULL<AST=NullConst>;
    EQEQ<AST=Equality.Eq>;
    NE<AST=Equality.Ne>;
    GT<AST=Comp.Gt>;
    LT<AST=Comp.Lt>;
    GE<AST=Comp.Ge>;
    LE<AST=Comp.Le>;
    INSTANCEOF<AST=Is>;
    LIKE<AST=Comp.Like>;
    COUNT<AST=Aggregate.Count>;
    AVG<AST=Aggregate.Avg>;
    MIN<AST=Aggregate.Min>;
    MAX<AST=Aggregate.Max>;
    SUM<AST=Aggregate.Sum>;
    ID<AST=Identifier>;
    THIS<AST=Identifier.This>;
    SUPER<AST=Identifier.Super>;
    RELAY<AST=Args>;

    BOOLEAN<AST=TypeSpec.Bool>;
    BYTE<AST=TypeSpec.Int8>;
    SHORT<AST=TypeSpec.Int16>;
    INT<AST=TypeSpec.Int32>;
    LONG<AST=TypeSpec.Int64>;
    CHAR<AST=TypeSpec.Char>;
    FLOAT<AST=TypeSpec.Real32>;
    DOUBLE<AST=TypeSpec.Real64>;

    LITERAL_STRING<AST=StringConst>;
    LITERAL_REGEXP<AST=RegExpConst>;
    LITERAL_DECIMAL<AST=DecimalConst>;
    LITERAL_REAL<AST=RealConst>;
    LITERAL_INTEGER<AST=IntConst>;
    LITERAL_TIME<AST=TimeConst>;
    LITERAL_INTERVAL<AST=IntervalConst>;
    TRUE<AST=BoolConst.True>;
    FALSE<AST=BoolConst>;

    UNARY_ADD;
    NEGATE;

    IS<AST=Is>;
    IN<AST=In>;
    AS<AST=Alias>;
    RANGE<AST=Range>;
    QUESTION<AST=ExprIf>;
    LPAREN<AST=Function>;
    LBRACK<AST=ArrayReference>;
    DOT<AST=MemberReference>;
    COLON<AST=Declaration>;
    IF<AST=If>;
    WHILE<AST=While>;
    FOR<AST=JavaFor>;
    FOREACH<AST=ForEach>;
    RETURN<AST=Return>;
    THROW<AST=Throw>;
    FROM<AST=Tables>;
    GROUP<AST=GroupByColumns>;
    CATCH<AST=On>;
    FINALLY<AST=OnExit>;
    EQ<AST=Assignment>;
    ORDER<AST=OrderBy>;
    HAVING<AST=Having>;
    ASC<AST=OrderBy.Col>;
    DESC<AST=OrderBy.DescCol>;
    DISTINCT<AST=Identifier.Distinct>;
    EXISTS<AST=Exists>;
    CAT<AST=StringCat>;
    SWITCH<AST=Switch>;
    CASE<AST=Switch.Case>;
    ORDERED<AST=Identifier.Ordered>;
    ENUM<AST=TypeSpec.Enum>;

    DISPLAY<AST=Display>;
    LOGMESSAGE<AST=Log>;
    INPUT<AST=Input>;


    // sql nodes
    SELECT<AST=Select>;
    EXISTS<AST=Exists>;
    ORDER<AST=OrderBy>;
    HAVING<AST=Having>;
    ASC<AST=OrderBy.Col>;
    DESC<AST=OrderBy.DescCol>;
    DISTINCT<AST=Identifier.Distinct>;
    FROM<AST=Tables>;
    GROUP<AST=GroupByColumns>;
    AS<AST=Alias>;
    BETWEEN<AST=In>;
    COUNT<AST=Aggregate.Count>;
    AVG<AST=Aggregate.Avg>;
    MIN<AST=Aggregate.Min>;
    MAX<AST=Aggregate.Max>;
    SUM<AST=Aggregate.Sum>;
    LIKE<AST=Comp.Like>;


    DEREF;
    METHOD;
    BLOCK;
    QUALIFIED;
    INSERT;
    DELETE;
    UPDATE;
    INVOKE;
    SET_MEMBER;
    SET_ELEMENT;
    TRANSFORM;
    OBJECT_INPUT;
    INSERTCOLUMNS;
    SETVALUES;
    FIELDS;
    FIELD;
    FORMAL_ARG;
    NULL_STATEMENT;
    CASES;
    COLUMNS;
    TABLES;
    ARRAY;
    MAP;

}

{
     void checkValidExpressionStatement(Node exp) 
             throws fuego.parser.SemanticException { /* overriden */ }
}

//===================== The grammar =================================


method!		:   r:resultType id:ID a:formalArgs
			b:block
		    {
		        #method = new Method(#id, #a, #r, #b);
		    }

		    EOF!
		;


methodBody	: statements EOF!
		    { Block block = new Block(); #methodBody = #(block, methodBody); }
		;

resultType!	: VOID
                    { #resultType = new FormalArgument.Result(); }
                | t:typeSpec
                    { #resultType = new FormalArgument.Result(#t); }
		;

formalArgs	: LPAREN! (formalArg (COMMA! formalArg)*)? RPAREN!
		;

formalArg!	:   mode:argMode t:typeSpec id:ID
                    {
                        #formalArg = new FormalArgument(#mode, #id, #t);
                    }
		;


argMode!        :   ( IN OUT  { #argMode = new Arg.Type(Argument.IN | Argument.OUT); }
                    | IN      { #argMode = new Arg.Type(Argument.IN); }
		    | OUT      { #argMode = new Arg.Type(Argument.OUT); }
		    |         { #argMode = new Arg.Type(Argument.IN); }
		)
                ;

typeParameters  :   LT^<AST=NList> typeParametersList GT!
		;

enumLabels  :   LBRACE^<AST=NList>  ID (COMMA! ID)* RBRACE!
		;


block		: LBRACE^<AST=Block> statements RBRACE!
		;

scopedBlock	: LBRACE^<AST=DoBlock> statements RBRACE!
		;
statements      : emptyStatement
		| (statement)+
                ;

emptyStatement  : // empty
		;
		
blockOrStatement!	: s:blockOrStatementBody
                    { #blockOrStatement = (#s instanceof Block) ? #s : new Block(#s); }
                ;

blockOrStatementBody: ((LBRACE) => block | statement)
		;
		
declaration	: t:typeSpec! varDeclaration[Node.deepCopy(#t)] (COMMA! varDeclaration[Node.deepCopy(#t)])*
		;

varDeclaration![AST t]  : id:ID (EQ init:expression)?
                    {
                        #varDeclaration = new Declaration(#id, #t, #init);
                    }
		;
langStatement	:  ifStatement
		|  forStatement
		|  foreachStatement
		|  whileStatement
		|  switchStatement
		|  exitStatement SEMICOLON!
		|  returnStatement SEMICOLON!
		|  throwStatement  SEMICOLON!
		|  (LBRACE) => scopedBlock
		|  tryBlock
		|  (declaration)=> declaration SEMICOLON!
		|  (COMPLETION EOF) => COMPLETION
		|  e:expression SEMICOLON! { checkValidExpressionStatement(#e); }
		|  displayStatement SEMICOLON!
		|  logStatement SEMICOLON!
		|  inputStatement SEMICOLON!
		|  labeledStatement
		|  SEMICOLON! // empty statement
		;
		exception catch [NoViableAltException e] {
		    reportError(e);
		    skipToNewLine();
		}
		catch [RecognitionException e] {
		    #langStatement = handleException(e, "statement");
		}
        exception[semi] catch [MismatchedTokenException e] {
		    reportError(e);
		    skipToNewLine();
        }

labeledStatement: ID COLON^<AST=LabeledStatement> statement
		;

ifStatement	: IF^ LPAREN! expression RPAREN! blockOrStatement
                     ((ELSE IF)=> ELSE! ifStatement
                     | (ELSE) => ELSE! blockOrStatement
                     | // Empty
                     )
		;


forStatement    : f:FOR! LPAREN!
                      ( (typeSpec ID COLON) => t:typeSpec! id:ID! COLON! expression
                        {  Node fea = new ForEach(f);
                           Node dec = new Declaration(#id, #t, null);
                           #forStatement = #(fea, dec, forStatement); }
                      | forInit SEMICOLON! forCond SEMICOLON! expressionList
                        { #forStatement = #(f, forStatement); }
                      ) RPAREN! blockOrStatement
		;

forInit		:   ( (declaration) => declaration
			{ #forInit = new NList(#forInit); }
		    | expressionList
		    )
		;

expressionList  : (expression (COMMA! expression)*)?
			{ #expressionList = new NList(#expressionList); }
		;

forCond		: expression
		| // Empty
			{ #forCond = new BoolConst(true); }
		;

foreachStatement:   FOREACH^ LPAREN! ID IN!
			( (COMPLETION EOF) => COMPLETION EOF!
                | (ID) => {isSQLSelect()}?
		    			{ setInsideSQL(true); }
		    		fullQuery
		    			{ setInsideSQL(false); }
		    	| expression
		    	)
		    RPAREN!
		    blockOrStatement
		;


whileStatement	: WHILE^ LPAREN! expression RPAREN! blockOrStatement
		;

switchStatement : SWITCH^<AST=Switch> LPAREN! expression RPAREN! LBRACE! (switchCase)+ RBRACE!
		;

switchCase	: 	( CASE^<AST=Switch.Case> switchCases
			| DEFAULT^<AST=Switch.Default> COLON!
			)
			caseStatements
		;

caseStatements!	: s:statementsUntilBreak
                    { #caseStatements = (#s instanceof Block) ? #s : new Block(#s); }
                ;

statementsUntilBreak 	: (BREAK SEMICOLON) =>	BREAK! SEMICOLON! 	
			|	statement
				( statementsUntilBreak
				| (CASE | DEFAULT | RBRACE) => { match(BREAK); }
				)
			;

switchCases	: expression (COLON! CASE! expression)* COLON^<AST=SwitchCases>
		;

exitStatement	: BREAK^<AST=Exit> (id)?
		;

returnStatement : RETURN^  expression
		;

throwStatement  : THROW^  expression
		;

tryBlock	: TRY^<AST=DoBlock> block onStatements
		;

onStatements	: (onStatement)*
			{ #onStatements = new Block(#onStatements); }
		;

onStatement	: FINALLY^ block
		| CATCH^ LPAREN! exceptionType ID RPAREN! block
		;

typeName        : name
		| builtInType
		;

builtInType     : BOOLEAN
                | BYTE
                | SHORT
		| INT
		| LONG
		| CHAR
                | FLOAT
		| DOUBLE
		;

displayStatement: DISPLAY^ LPAREN! expression (COMMA! args)?  RPAREN! (relay)?
                ;

                // In and Out arguments in any order
args            : argList
		;

logStatement    : LOGMESSAGE^ LPAREN! expression (COMMA! args)?  RPAREN!
                ;

inputStatement	: (INPUT LPAREN LITERAL_STRING) => INPUT^ LPAREN! fields RPAREN! (relay)?
		| (INPUT LPAREN ID basicReference) => INPUT^ LPAREN! fields RPAREN! (relay)?
		| INPUT^<AST=ObjectInput> LPAREN! basicReference (COMMA! args)? RPAREN! (relay)?
		;

fields		: field (COMMA! field)*
		;

field		: (LITERAL_STRING) => LITERAL_STRING basicReference (fieldOptions)? (fieldArray)?
		       { #field = new InputField(#field); }
		| (ID basicReference) => ID basicReference (fieldOptions)? (fieldArray)?
		       { #field = new InputField(#field); }
		| arg
		;
basicReference  : primaryRef (DOT^ idOrNumber)*
		;

fieldOptions	: LPAREN^ fieldOption (COMMA! fieldOption)* RPAREN!
		;

fieldOption 	: id (EQ^ constant)?
		;

fieldArray	: (IN^ expression)
		;

relay		:  RELAY! (TO!)? ID 
		   LPAREN! argList RPAREN!
		;

//- Expression Staff

expression      : assignmentExpression
		;
		exception catch [RecognitionException e] {
		    #expression = handleException(e, "expression");
		}

newExpr 	: methodCall (DOT^ (methodCall2 | COMPLETION))*
                ;

methodCall	:  ID  (DOT^ ID)* LPAREN^ argList RPAREN!
        	;

methodCall2	:  qname (LPAREN argList RPAREN!)?
        	;

qname 		: ID	( (DOT) => DOT^ qname
	   		| // Empty
	   		)
		;



assignmentExpression : r:conditionalExpr
			 (EQ^ e:assignmentExpression
				 {
				    if (#r.getType() == DOT || #r.getType() == LBRACK) {
					Node node = #r.getType() == DOT ? new SetMember() : (Node) new SetElement();
					Node refArgs = (Node) #r.getFirstChild();
					#assignmentExpression = #(node, refArgs, #e);
				    }
				 }
			 | // Empty
			 )
		;

conditionalExpr : orExpr ( QUESTION^ assignmentExpression COLON! conditionalExpr )?
		;

orExpr		: andExpr (OR^ andExpr)*
		;


andExpr		: notExpr (AND^ notExpr)*
		;

notExpr		: NOT^ notExpr
		| e:equalityExpr (INSTANCEOF^ typeSpec)?
		;

equalityExpr	: relationalExpr
		    ( ( NE^ | EQEQ^) relationalExpr )*
		;


relationalExpr	: addExpr ( (IN^ | LT^ | GT^ | LE^ | GE^ | LIKE^) addExpr)?
		;


addExpr		:   multExpr ((ADD^ | SUB^) multExpr)*
		;

multExpr	: castExpr ( (MUL^ | DIV^ | REM^ ) castExpr)*
		;

castExpr	: (LPAREN typeSpec RPAREN castExpr) => LPAREN! t: typeSpec RPAREN! e: castExpr
                  { #castExpr = new Cast(#e, #t); } // invert type and expr
		| unaryExpr (TO^<AST=TransformCall> typeSpec LPAREN! typeSpec RPAREN!)?
		;

unaryExpr	: INC^ unaryExpr
		| DEC^ unaryExpr
		| SUB^<AST=UnaryArithmetic.UMinus>	unaryExpr
		| ADD^<AST=UnaryArithmetic.UPlus>	unaryExpr
		| NEW! newExpr
		| postFixExpr
		;

postFixExpr	: reference
			( INC^<AST=IncDecOperator.PostInc>
			| DEC^<AST=IncDecOperator.PostDec>
			)?
		;

reference	: primaryRef
                  	( options {
                                generateAmbigWarnings=false;
                            }
                        :
                            DOT^ idOrNumber
			|   (LBRACK RBRACK DOT) => LBRACK^<AST=MappedArrayReference> RBRACK! DOT! ID
			|   LBRACK^ (expression)? RBRACK!
			|   LPAREN^ argList RPAREN! (relay)?
			)*
			    {
				 if (#reference instanceof Identifier)
				 	#reference = new Deref(#reference);
			    }
		;

id		: ID
		| COMPLETION
                ;

idOrNumber      : ID
		| LITERAL_INTEGER
		| COMPLETION
                ;

primaryRef      : p:primary  { Deref deref = new Deref(); #primaryRef = #(deref, #p); }
		| value
		| LBRACE^<AST=ArrayConst> (arrayElements)? RBRACE!
		| ID
		;

value           : LPAREN! expression (COMMA! expression)* RPAREN!
		;
		
primary		: THIS
		| SUPER
		| COMPLETION
		| constant
		| builtInType
		;

arrayElements	: arrayElement (COMMA! arrayElement)*
		;

arrayElement	: expression
		      ( COLON^<AST=Pair> expression
		      | // Empty
		      )
		;

argList		: arg (COMMA! arg)*
		| // Empty
		;

arg             : argMode namedExpression
                ;

namedExpression : ID COLON^<AST=NamedNode> expression
		| expression
		;

