// - Copyright Notice
// -----------------------------------------------------------------------
// (C) Copyright 1998 Fuego Inc.  All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Fuego Inc.
// The copyright notice above does not evidence any actual or intended
// publication of such source code.
//
// $Id: FuegoBaseParser.g 98820 2009-06-04 14:06:28Z diegor $
// -----------------------------------------------------------------------

header {
    package oracle.bpm.compiler;
}

options {
    mangleLiteralPrefix="";
    upperCaseMangledLiterals=true;
}


// Import the necessary classes
{
    import oracle.bpm.compiler.FuegoLexer;
}

class FuegoBaseParser
    extends Parser;

options {
    classHeaderSuffix="FuegoParser";
    defaultErrorHandler=false;
    k = 2;			     // two token lookahead
    codeGenMakeSwitchThreshold = 2;  // Some optimizations
    codeGenBitsetTestThreshold = 3;
    buildAST = true;
    ASTLabelType = "Node";

    
    inlineASTFactory = true;
    baseClass = "AbstractCILParser";
}


//Java code

statement	: { isSQLStatement() }?
		    { setInsideSQL(true); }
		    sqlStatement
		    { setInsideSQL(false); }
		| langStatement
		;

oldStatement	: { isSQLStatement() }?
		    { setInsideSQL(true); }
		    sqlStatement
		    { setInsideSQL(false); }
		| oldLangStatement
		;
oldLangStatement:;

expressionOnly	:   (expression)? EOF!
		;

typeSpec	: n:typeName (p:typeParameters)? (a:arraySpec)?
                    {
                        #typeSpec = TypeSpec.make(#n, #p, #a);
                    }
            	| ENUM^<AST=TypeSpec.Enum> ID enumLabels
                ;

typeName        : name
		;

typeParametersList:	( typeSpec (COMMA! typeSpec)*
			| LITERAL_INTEGER  (COMMA! LITERAL_INTEGER )?
			)
                ;

arraySpec       : LBRACK^<AST=NList>  indexSpec RBRACK! (LBRACK! indexSpec RBRACK!)*
                ;

indexSpec       : ORDERED! t:typeSpec
                    {
                        ((TypeSpec)#t).setOrdered(true);
                    }
                | typeSpec
                | // Empty
                    { #indexSpec = new TypeSpec.Void(); }
                ;

name		: COMPLETION 
		| ID (DOT! (ID | COMPLETION) )*
                    {
                        #name = new QualifiedName(#name);
                    }
		;

exceptionType	: n:name
                    {
                        #exceptionType = new TypeSpec(#n);
                    }
                ;

constant        : literalValue		
		| TRUE
		| FALSE
		| NULL
		;

sqlConstant     : literalValue		
		| TRUE
		| FALSE
		| NULL
		;

literalValue	: LITERAL_STRING
		| LITERAL_DECIMAL
		| LITERAL_REAL
		| LITERAL_INTEGER
		| LITERAL_TIME
		| LITERAL_INTERVAL
		| LITERAL_REGEXP
		;
		
// ================================================== SQL ===========================================================

table	        : n:name
                    {
                        #table = new TypeSpec.CaseInsensitive(#n);
                    }
 		;

sqlStatement	: insertStatement
		| deleteStatement
		| updateStatement
		| ID // Dummy to fool ANTLR
		;

insertStatement : INSERT^<AST=Insert> INTO! table (insertColumns)? (NL!)* insertValues
		;

insertColumns	: LPAREN^<AST=Insert.Columns> ID (COMMA! ID)* RPAREN!
		;

insertValues	: VALUES^<AST=Insert.Values> LPAREN! sqlExpression (COMMA! (NL!)* sqlExpression)* RPAREN!
		| selectExpr
		;


deleteStatement : DELETE^<AST=Delete> FROM! table whereClause
		;

whereClause	: ((NL)+ WHERE) => (NL!)+ WHERE! sqlBooleanExpression
		| WHERE! sqlBooleanExpression
		| // Empty
		;

updateStatement : UPDATE^<AST=Update> table updateSetValues whereClause
		;

updateSetValues : (NL!)* SET^<AST=Update.SetValues> updateSetValue (COMMA! (NL!)* updateSetValue)*
		;

updateSetValue	: updateSetField EQ^<AST=Assignment> sqlExpression
		;

updateSetField  : ID 		
			{ #updateSetField = new SqlColumnReference(#updateSetField); }
		;


fullQuery      	: SELECT^ (DISTINCT | ALL!)?
		    columns           
		    from               
		    whereClause     
		    (groupBy (having)?)? 
		    (orderBy)?        
		| ID // Dummy to fool ANTLR
		;

selectExpr	: SELECT^ (DISTINCT | ALL!)?
		    columns
		    from
		    whereClause
		    (groupBy (having)?)?
		;


columns		: MUL^<AST=SelectColumns>
		| column (COMMA! column)* { #columns = new SelectColumns(#columns); }
		;

column		: sqlExpression (AS^<AST=Alias> ID)?
		;

from		: (NL!)* FROM^ table (COMMA! table)*
		;

groupBy	    	: GROUP^ BY! name (COMMA! name)*
	    	;

having		: HAVING^ sqlBooleanExpression
		;

orderBy		: (NL!)? ORDER^ BY! orderByColumn (COMMA! orderByColumn)*
		;

orderByColumn	: (LITERAL_INTEGER | name) (ASC^ | DESC^)?
		    { int t = #orderByColumn.getType();
			if (t != ASC && t != DESC) {
			    #orderByColumn = new OrderBy.Col(#orderByColumn);
			}
		    }
		;


sqlExpression   : sqlTerm
			( (ADD|SUB) => (ADD^ | SUB^) sqlExpression
			| // Empty
			)
		;

sqlTerm		: sqlFactor 	( (MUL|DIV) => (MUL^ | DIV^) sqlTerm
				| // Empty
				)
		;

sqlFactor	: sqlBaseFactor ((CAT)=> CAT^ sqlFactor
				| // Empty
				)
      		;

sqlBaseFactor	: sqlConstant
		| ( ADD^<AST=UnaryArithmetic.UPlus> | SUB^<AST=UnaryArithmetic.UMinus>)  sqlExpression
	    	| COUNT^ LPAREN! (MUL | (ALL! | DISTINCT)? sqlExpression) RPAREN!
	    	| (AVG^ | MAX^ | MIN^ | SUM^) LPAREN! (ALL! | DISTINCT)? sqlExpression RPAREN!
      		| (sqlFunctionId LPAREN) => sqlFunction
      		| LPAREN! sqlExpression RPAREN!
      		| n:sqlReference 
		  ( LBRACK^<AST=ArrayReference> sqlExpression RBRACK! 
		   (DOT^<AST=MemberReference> ID)* 
		  )*
    		;

sqlFunction     : sqlFunctionId LPAREN^ (sqlArgList)? RPAREN!
		;
		
sqlFunctionId   : ID (DOT^<AST=MemberReference> ID)*
		;

sqlArgList	: sqlArg (COMMA! (NL!)* sqlArg)*
		;

sqlArg		: e:sqlExpression 
                  { #sqlArg = new Arg.Type(Argument.IN); 
		    #sqlArg.setNext(#e); }
		;

sqlReference	: name
			{ #sqlReference = new SqlColumnReference(#sqlReference); }
		| THIS (DOT^<AST=MemberReference> id)+
		| COLON^<AST=Deref> id
		;

// Redefine if Host language use another syntax.

arrayIndex	: LBRACK! sqlExpression RBRACK!
		;

sqlBooleanExpression  : sqlLogicalTerm ((OR) => OR^ sqlBooleanExpression
					| // Empty
					)
		;

sqlLogicalTerm : sqlLogicalFactor 	((AND) => AND^ sqlLogicalTerm
					| // Empty
					)
		;

sqlLogicalFactor: (LPAREN sqlBooleanExpression) => LPAREN! e:sqlBooleanExpression RPAREN!
                    { #e.setParenthesis(true); }
		| sqlExpression
			(
				( EQ^<AST=Equality.Eq> | NE^ | LT^ | GT^ | LE^ | GE^ ) sqlExpression
			|	((NOT)? IN) => (NOT)? IN^ sqlSet
			|	((NOT)? BETWEEN) => (NOT)? BETWEEN^ sqlExpression AND! sqlExpression
			|	((NOT)? LIKE) => (NOT)? LIKE^ sqlExpression
			|	IS^ (NOT)? NULL
			|	NOT^ sqlBooleanExpression
			)
			|	((NOT)? EXISTS) => (NOT)? EXISTS^ LPAREN! (NL!)* selectExpr (NL!)* RPAREN!
		;

sqlSet		: LPAREN!
		( sqlExpression (COMMA! sqlExpression)*
		| selectExpr
		)
	  	RPAREN!
		;
