<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="*">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="text()">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body>
				<xsl:attribute name="bgcolor"><xsl:value-of select="presentation/@bgcolor"/></xsl:attribute>
				<title>
					<xsl:value-of select="presentation/@id"/>
				</title>
				<form>
					<xsl:attribute name="name"><xsl:value-of select="presentation/@id"/></xsl:attribute>
					<xsl:apply-templates/>
				</form>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="table">
		<table>
			<xsl:attribute name="width"><xsl:value-of select="@width"/>%
			</xsl:attribute>
			<xsl:attribute name="align"><xsl:value-of select="@alignment"/></xsl:attribute>
			<xsl:attribute name="cellpadding"><xsl:value-of select="@cellpadding"/></xsl:attribute>
			<xsl:attribute name="cellspacing"><xsl:value-of select="@cellspacing"/></xsl:attribute>
			<xsl:attribute name="border"><xsl:if test="@border = &quot;true&quot;">1</xsl:if><xsl:if test="@border = &quot;false&quot;">0				</xsl:if></xsl:attribute>
			<xsl:apply-templates/>
		</table>
	</xsl:template>
	<xsl:template match="row">
		<tr>
			<xsl:apply-templates/>
		</tr>
	</xsl:template>
	<xsl:template match="cell">
		<td>
			<xsl:attribute name="colspan"><xsl:value-of select="@hexpand"/></xsl:attribute>
			<xsl:attribute name="rowspan"><xsl:value-of select="@vexpand"/></xsl:attribute>
			<xsl:attribute name="bgcolor"><xsl:value-of select="@bgcolor"/></xsl:attribute>
			<font>
				<xsl:attribute name="color"><xsl:value-of select="@fgcolor"/></xsl:attribute>
				<xsl:if test="@fonsize > &quot;0&quot;">
					<xsl:attribute name="size"><xsl:value-of select="@fontsize"/></xsl:attribute>
				</xsl:if>
			<div>
				<xsl:attribute name="align"><xsl:value-of select="@alignment"/></xsl:attribute>

				<xsl:choose>
					<xsl:when test="@fontface = &quot;BOLD&quot;">
						<b>
						<br/>
						<xsl:apply-templates/>
						</b>
					</xsl:when>
					<xsl:when test="@fontface = &quot;ITALIC&quot;">
						<i>
						<br/>
						<xsl:apply-templates/>
						</i>
					</xsl:when>
					<xsl:when test="@fontface = &quot;BOLD_ITALIC&quot;">
						<b><i>
						<br/>
						<xsl:apply-templates/>
						</i></b>
					</xsl:when>
					<xsl:otherwise>
						<br/>
						<xsl:apply-templates/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			</font>
		</td>
	</xsl:template>
	<xsl:template match="value">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="text">
		<input type="text">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:attribute name="size"><xsl:value-of select="@colqty"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:apply-templates/></xsl:attribute>
		</input>
	</xsl:template>
	<xsl:template match="multilinetext">
		<textarea type="text">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:attribute name="rows"><xsl:value-of select="@lineqty"/></xsl:attribute>
			<xsl:attribute name="cols"><xsl:value-of select="@colqty"/></xsl:attribute>
			<xsl:apply-templates/>
		</textarea>
	</xsl:template>
	<xsl:template match="label">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="radio">
		<table border="1"><tr><td>
			<table>
				<tr><td><input type="radio" name="radio">abc0</input></td></tr>
				<tr><td><input type="radio" name="radio">abc1</input></td></tr>
				<tr><td><input type="radio" name="radio">abc2</input></td></tr>
				<tr><td><input type="radio" name="radio">abc3</input></td></tr>
				<tr><td><input type="radio" name="radio">abc4</input></td></tr>
			</table>	
		</td></tr></table>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="check">
		<input type="checkbox">
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="value/@display"/></xsl:attribute>
		</input>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="combo">
		<select>
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
		<xsl:apply-templates/>
		</select>
	</xsl:template>
	<xsl:template match="array">
		<table>
			<xsl:attribute name="cellpadding"><xsl:value-of select="@cellpadding"/></xsl:attribute>
			<xsl:attribute name="cellspacing"><xsl:value-of select="@cellspacing"/></xsl:attribute>
		<tr>
			<xsl:apply-templates/>
		</tr>
		</table>
	</xsl:template>
	<xsl:template match="image">
		<a>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="@id"/>.gif</xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:apply-templates/>
			</img>
		</a>
	</xsl:template>
	<xsl:template match="button">
		<input>
			<xsl:attribute name="type"><xsl:value-of select="@action"/></xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@display"/></xsl:attribute>
		</input>
		<xsl:apply-templates/>
	</xsl:template>
</xsl:stylesheet>
