/******************************************************************************
 Fuego JS: XO Form

 Author: Nicolas Damonte
 Build:  1.00
******************************************************************************/

//Vars
var changedComps 	    = "";
var lastFocusElementId      = "";
var lastElementValue = "";
var groupSelectedIndexes    = "";
var executeResponseErrorMessage  = "";
var loadingMessage = "Loading";
var disableFormElementMap = null;
var hasTimer = false;
var isServerBusy = false;
var executionStack = new Array();
var remoteScriptUnknownResponseMsg = "Unknown response type.\nThe portal might be experiencing technical difficulties.";
var actionInProgress = false;

/*
* This function appends to changedComps var the id of the changed component
* @param attId The id of the attribute
* @param onChange It is a boolean to know if the element has a real onchange to do.
*/
function valueChanged(attId, onchange)
{
    if(changedComps.indexOf(attId+",") == -1)
    {
	changedComps += attId + ","
    }

    if(onchange)
    {
	doXoAction(13, attId)
    }
}

/*
* Sets local var groupSelectedIndexes which represents the selected indexes of a group
*/
function setGroupSelectedIndexes(indexes)
{
	groupSelectedIndexes = indexes;
}

/*
* Sets local var lastFocusElementId which represents the id of the last focused element
*/
function setLastFocusElement(id)
{
	lastFocusElementId = id;
}

/*
* Resets local vars
*/
function resetVars()
{
	setGroupSelectedIndexes("");
	setLastFocusElement("");
	changedComps = "";
	resetGroupMap();
	resetCursor();
}

/*
* Applies focus to the element of the given name
*/
function setFocusOnElement(elementId)
{
	try
	{
		theElement = document.getElementById(elementId);

		if(theElement != null && theElement.focus){
			    window.setTimeout("try{document.getElementById('" + elementId + "').focus();}catch(e){}",100);
		}
	}catch(e){
	    //Nothing to do
	}
}

function xoSubmitHandler()
{
	return true;
}

function xoResetHandler()
{
	return true;
}


function setWaitCursor()
{
    setCursor("wait");
    showLoadingMessage();
}

function resetCursor()
{
    setCursor("auto");
    hideLoadingMessage();
}

function showLoadingMessage(){
	var disabledZone = document.getElementById('disabledZone')
	if(disabledZone == null){
        disabledZone = document.createElement('div');
        disabledZone.style.left = "0px";
		disabledZone.style.top = "0px";
		disabledZone.style.width = "100%";
		disabledZone.style.height = "100%";
        disabledZone.setAttribute('id', 'disabledZone');
        disabledZone.style.position = "absolute";
        disabledZone.style.zIndex = "1000";        
        document.body.appendChild(disabledZone);
		var messageZone = document.createElement('div');
		messageZone.style.padding = "4px";
		messageZone.className = "headerWait";
        messageZone.setAttribute('id', 'messageZone');
        messageZone.style.position = "absolute";
        messageZone.style.top = "0px";
        messageZone.style.right = "0px";
        disabledZone.appendChild(messageZone);
		var text = document.createTextNode(loadingMessage);
		messageZone.appendChild(text);
	}

	disabledZone.style.visibility = 'visible';

}

function hideLoadingMessage(){
	var disabledZone = document.getElementById('disabledZone')
	if(disabledZone != null){
		disabledZone.style.visibility = 'hidden';
	}
}

function getCursor()
{
    return document.body.style.cursor;
}

function setCursor(cursorType)
{
    document.body.style.cursor = cursorType;
}

function setCursorToElement(theElement, theCursorType)
{
    if(theElement != null)
    {
        theElement.style.cursor = theCursorType;
    }
}

function setActionInProgress(boolFlag){
    actionInProgress = boolFlag;
}

function isActionInProgress(){
    return actionInProgress;
}



/*
* Graphic Action controller
*/
function doXoGraphicAction(act, ids, params)
{
    if(isSubmitAllowed() && ids != null && ids.length > 0)
    {
        if(remoteScripting && isRemoteScriptSupported())
        {
            //Change cursor icon to WAIT
            setWaitCursor();

            var response = callServerWithParams(document.xobjectForm, act, ids.join(), params);
            handleGraphicResponse(ids, response);
            return true;

        } else {
            return doXoAction(act, ids);
        }
    } else {
        return false;
    }
}


/*
* Presentation Action controller
*/
function doXoAction(act, id)
{
    return doXoAction2(act, id, false);
}


/*
* Presentation Action controller
*/
function doXoAction2(act, id, forceNonRemoteScript)
{
    if(!isActionInProgress())
    {
        if(isSubmitAllowed())
        {
            //Setting action in progress flag
            setActionInProgress(true);
            //Change cursor icon to WAIT
            setWaitCursor();
            //Disabling Form elements
            disableFormElements(document.xobjectForm);

            //alert("Browser -> "+jsrsBrowser);
            if(!forceNonRemoteScript && remoteScripting && isRemoteScriptSupported())
            {
                //alert("REMOTE SCRIPT!");
                window.setTimeout("handleActionByRemoteScripting(" + act + ", '" + id + "', "+ forceNonRemoteScript + ");",10);

            } else {
                //alert("REPOSTERO!");
                handleActionByReposting(act, id, forceNonRemoteScript);
            }
            return true;
        } else {
            return false;
        }
    } else {
        //alert("Please wait. There is a request in process.");
        return false;
    }
}

function handleActionByRemoteScripting(act, id, forceNonRemoteScript)
{
    var response = callServer(document.xobjectForm, act, id);
    handleResponse(response);

    //Setting action in progress flag
    window.setTimeout("setActionInProgress(false);",100);
}

function handleActionByReposting(act, id, forceNonRemoteScript)
{
    try{
        document.xobjectForm.xo$Action.value = act;
        document.xobjectForm.xo$AttName.value = id;
        document.xobjectForm.xo$ChangedAtts.value = changedComps;
        document.xobjectForm.xo$lastFocusElement.value = lastFocusElementId;

        //Has timer?
        if(hasTimer){
            //Setting current timer values
            document.xobjectForm.xo$TimerValues.value = getTimerValues();
            //resetting timer
            resetTimer();
        }

        //Setting group's selected indexes
        if(groupSelectedIndexes != null && groupSelectedIndexes != "")
        {
            document.xobjectForm.xo$GroupIndexes.value = groupSelectedIndexes;
        }

        //BUG 12126 (Workaround)
        if(navigator.appName != "Microsoft Internet Explorer" && (act == 7 || act == 9 || act == 11))
        {
            window.setTimeout("document.xobjectForm.submit();",100);
        } else {
            document.xobjectForm.submit();
        }
    }catch(e){
        resetCursor();
        enableFormElements(document.xobjectForm);
        setActionInProgress(false);
    }
}

function enableFormElements(theForm){
	if(theForm != null)
	{
	    try
	    {
                for(var i=0; i<theForm.elements.length; i++)
                {
                        var theElement = theForm.elements[i];

                        if(theElement != null)
                        {
                            if(theElement.type == "button"){
                                    theElement.style.cursor = "auto";
                                    if(remoteScripting){
                                        if(disableFormElementMap != null && disableFormElementMap[theElement.id])
                                        {
                                            theElement.disabled = false;
                                        }
                                    }
                            }
                        }
                }
            }catch(e){
                //Nothing to do
            }

            disableFormElementMap = null;
        }
}

function disableFormElements(theForm){
	if(theForm != null)
	{
	    try
	    {
                for(var i=0; i<theForm.elements.length; i++)
                {
                        var theElement = theForm.elements[i];

                        if(theElement != null)
                        {
                            if(theElement.type == "button"){
                                    theElement.style.cursor = "wait";
                                    if(remoteScripting){
                                        if(disableFormElementMap == null){
                                            disableFormElementMap = [];
                                        }
                                        if(!theElement.disabled){
                                            disableFormElementMap[theElement.id] = true;
                                            theElement.disabled = true;
                                        }
                                    }
                            }
                        }
                }
            }catch(e){
                //Nothing to do
            }
        }
}

function printFuegoObject(){
    bV = parseInt(navigator.appVersion);
	if (bV >= 4) window.print();
}

/**
* Remote scripting execution caller
*/
function callServer(theForm, act, id)
{
    return callServerWithParams(theForm, act, id, null);
}

/**
* Remote scripting execution caller
* Sync
*/
function callServerWithParams(theForm, act, id, extraParams)
{
    waitServer();
    serverBusy();
    var result = serverCall(theForm, act, id, extraParams);
    serverReady();
    return result;
}

/**
* Remote scripting execution caller
*/
function serverCall(theForm, act, id, extraParams){
    var url = buildUrl(theForm);
    var paramNames = getFuegoObjectFormParamNames();
    var paramValues= getFuegoObjectFormValues(act, id);

    if(extraParams != null){

        for(var i = 0; i < extraParams.length; i++)
        {
            var extraParamId = extraParams[i];
            var inputElement = document.getElementById(extraParamId);

            if(inputElement != null){

                if(paramNames != ""){
                    paramNames.concat(",");
                    paramValues.concat(",");
                }

                paramNames = paramNames.concat(extraParamId);
                paramValues = paramValues.concat(inputElement.value);
            }
        }
    }

    return execute( url, paramNames, paramValues, true);
}

function isServerBusy(){
    return isServerBusy;
}

function serverBusy(){
    isServerBusy = true;
}

function serverReady(){
    isServerBusy = false;
}

/*
* Exec syncronization
*/
function waitServer(){
    if(isServerBusy){
        var execId = executionStack.length == 0 ? 1 : executionStack[executionStack.length - 1] + 1;
        executionStack.push(execId);

        while(isServerBusy && (executionStack[0] != execId)){
            //Wait
            setTimeout("",100);
        }
        //Removes the exec from stack
        executionStack.shift();
    }
}

/**
* Handles the remote scripting execution response
*/
function handleResponse(html)
{
    //Cursor to default
    resetCursor();

    //Is a valid response?
    if(html != null) {
        // ---- PARSE RESPONSE ----

        //Parsing the response
        var dummyDivNode = document.createElement("DIV");
        dummyDivNode.innerHTML = html;

        var responseTypeNode = dummyDivNode.firstChild;

        if(responseTypeNode.innerHTML == 'RENDER'){

            // ---- RENDER -----

            //Nodes
            var fobjectHtmlNode = responseTypeNode.nextSibling;
            var fobjectMessagesNode = fobjectHtmlNode.nextSibling;
            var fobjectJsNode = fobjectMessagesNode.nextSibling;

            //Re-painting the form
            var form = document.getElementById('fobjectFormDiv');
            if(form != null && html != ""){
                var xoHtml = fobjectHtmlNode.innerHTML;
                evalScripts(xoHtml)
                form.innerHTML = xoHtml;
            }

            //Restoring focus
            setFocusOnElement(lastFocusElementId);

            //Show errors and constraints messages
            var msgStr = fobjectMessagesNode.innerHTML;
            document.getElementById('fobjecMsgDiv').innerHTML = msgStr;

            //Reseting components
            resetVars();

            //Performing script
            var scriptToPerform = fobjectJsNode.innerHTML;
            if(scriptToPerform != null && scriptToPerform != ""){
                window.setTimeout(scriptToPerform,100);
            }

        } else if(responseTypeNode.innerHTML == 'FINISH'){

            // ---- FINISH ----

            var fobjectFinishUrl = responseTypeNode.nextSibling;
            window.location = fobjectFinishUrl.getAttribute("url");

        } else if(responseTypeNode.innerHTML == 'CHILD'){

            // ---- SHOW ----
            var fobjectScreenId = responseTypeNode.nextSibling;
            var childActionId = fobjectScreenId.getAttribute("actionId");

            //Setting new screenId
            //document.xobjectForm.xo$ScreenSessKey.value = screenId;

            //Resetting flag
	    setActionInProgress(false);

            //Force a non remote script request
            doXoAction2(childActionId, "Repaint", true);

        } else {

            // ---- Unknown ??? ----

            handleUnknownResponse(html)
        }

        dummyDivNode = null;
    } else {
        // ---- Unknown ??? ----

        handleUnknownResponse(null);
    }
}

/**
 * Evaluates all scripts contained in the html text provided
 * @param html
 */
function evalScripts(html)
{
    var script, scripts;
    scripts = [];
    var regexp = /<script[^>]*>([\s\S]*?)<\/script>/gi;
    while ((script = regexp.exec(html))) scripts.push(script[1]);
    scripts = scripts.join('\n');

    if (scripts) (window.execScript) ? window.execScript(scripts) : window.setTimeout(scripts, 0);
}

/**
* Handles the remote scripting execution response
*/
function handleGraphicResponse(imageIds, response)
{
    //Is a valid response?
    if(response != null) {
        // ---- PARSE RESPONSE ----

        //Cursor to default
        resetCursor();

        //Parsing the response
        var dummyDivNode = document.createElement("DIV");
        dummyDivNode.innerHTML = response;

        //Response type
        var responseTypeDivElement = dummyDivNode.firstChild;

        if(responseTypeDivElement.innerHTML == 'GRAPHIC'){

            var currentInfoDivElement = responseTypeDivElement.nextSibling;
            var graphicInfos = new Array();

            while(currentInfoDivElement != null){

                //Only evaluating ELEMENT_NODES
                if(currentInfoDivElement.nodeType == 1)
                {
                    graphicInfos[currentInfoDivElement.getAttribute("id")] = currentInfoDivElement;
                }

                currentInfoDivElement = currentInfoDivElement.nextSibling;
            }

            for(var i = 0; i < imageIds.length; i++)
            {
                var imageId = imageIds[i];
                var graphicInfo = graphicInfos[imageId];

                var graphicDiv = document.getElementById(imageId);
                if(graphicDiv != null){
                    //Non refresh xml
                    if(graphicInfo.getAttribute("justJsToPerform") == null) {
                        graphicDiv.innerHTML = graphicInfo.innerHTML;
                    }
                    //Perform Javascript
                    var jsToPerform = graphicInfo.getAttribute("jsToPerform");
                    if(jsToPerform != null){
                        eval(""+jsToPerform);
                    }
                }else{
                    //alert("Javascript DOM Problem. Image object not found.");
                }
            }
        } else {
            // ---- Unknown ??? ----

            handleResponse(response)
        }

        dummyDivNode = null;
    }
}

function handleUnknownResponse(response){
    //Is response null?
    if(response != null){
	//Rendering the whole page if it is a HTML page
	response = trim(response);
	if(response.indexOf("<HTML>") != -1 || response.indexOf("<html>") != -1 || response.indexOf("<Html>") != -1){
		document.write(response);
	} else if(response.indexOf("EXECUTION_ABORTED") != -1) {
		window.location.reload(false);
	}
	} else {
		alert(remoteScriptUnknownResponseMsg);
		enableFormElements(document.xobjectForm);
	}
}

/**
* Builds the url to be used with remote scripting
*/
function buildUrl(theForm)
{
  return theForm.action;
}

/**
* Returns an array of values from the fuego object form
*/
function getFuegoObjectFormValues(act, id)
{
    var fixedValues = [""+act, ""+id, ""+changedComps, ""+docKey, ""+document.forms['xobjectForm'].elements['xo$ScreenSessKey'].value, "rscript"];

    if(groupSelectedIndexes != null && groupSelectedIndexes != ""){
        fixedValues = fixedValues.concat([groupSelectedIndexes]);
    }

    if(changedComps != null && changedComps != "")
    {
        //Parsing changed elements
        var changed = changedComps.split(',');


        if(changed != null && changed.length > 0){
            //Loading values
            var values = new Array(changed.length);
            for(var i = 0; i < changed.length -1; i++)
            {
                //values[i] = escape(eval('document.xobjectForm.' + changed[i] + '.value'));
                values[i] = document.forms['xobjectForm'].elements[changed[i]].value;
            }

            fixedValues = fixedValues.concat(values);
        }
   }

   return fixedValues;
}

/**
* Returns an array of names from the fuego object form
*/
function getFuegoObjectFormParamNames()
{
    var fixedNames = ["xo$Action", "xo$AttName", "xo$ChangedAtts", "xo$DocSessKey", "xo$ScreenSessKey", "xo$executionType"];

    if(groupSelectedIndexes != null && groupSelectedIndexes != ""){
        fixedNames = fixedNames.concat(["xo$GroupIndexes"]);
    }

    if(changedComps != null && changedComps.length > 0){
        var names = changedComps.split(',');
        fixedNames = fixedNames.concat(names);
    }

    return fixedNames;
}

/**
* Shows an error
*/
function showExecutionErrorMessage(errorMsg)
{
    //Cursor to default
    resetCursor();

    alert(errorMsg);
}

function refreshImage()
{
        window.setTimeout("doXoAction(28, 'Repaint');", 10);
}

function refreshImageOnChange(name)
{
    if (name != null) {
        window.setTimeout("doXoAction(13, '" + name + "');", 10);
    }
}

function graphicClick(clickActionId, id, categoryValue, seriesValues)
{

    var clickAtts = new Array();

    if(categoryValue != null){
        var categoryHidden = document.getElementById('fo$graphiclick$category');
        if(categoryHidden != null){
            categoryHidden.value = categoryValue;
            clickAtts = clickAtts.concat('fo$graphiclick$category');
        }
    }

    if(seriesValues != null){
        var seriesHidden = document.getElementById('fo$graphiclick$series');
        if(seriesHidden != null){
            seriesHidden.value = seriesValues;
            clickAtts = clickAtts.concat('fo$graphiclick$series');
        }
    }

    if(clickAtts.length == 0){
        clickAtts = null;
    }

    //Click
    if(clickActionId != -1)
    {
        //doXOAction
        doXoGraphicAction(clickActionId, id, clickAtts);
    }

}

function trim(s) {
  if(s != null && s.length > 0){
      while (s.substring(0,1) == ' ') {
        s = s.substring(1,s.length);
      }
      while (s.substring(s.length-1,s.length) == ' ') {
        s = s.substring(0,s.length-1);
      }
  }
  return s;
}

function enableTimer(){
    hasTimer = true;
}

function getMainOpenerWindow()
{
	var mainWin = window;
	while(mainWin.opener != null){
		mainWin = mainWin.opener;
	}

	return mainWin;
}
