/******************************************************************************
 Fuego JS: Validation library

 Author: Nicolas Damonte
 Build:  1.00
******************************************************************************/

//Vars
var selectedComponent = ":)"
var sign = "-"
var lastComponentName = "";
var lastComponentOriginalBgColor = "";
var lastComponentFormOnSubmit;
var isSubmitWithErrorAllowed = false;
var integerRegExp = /^([0-9]*)$/;
var decimalValues = new Array();


/*******************************************************************************************************
* Event Validations Methods
*******************************************************************************************************
To use these kind of methods:

- You must add this two lines to every textfield you want to validate (inline)
  onKeyDown="unselect(event);"
  onSelect="setSelectedComponent(this.name);"

- Then add the validation method in the onKeyPress event handler.

  Eg:

  - To validate Integer values.
    onKeyPress="return isInteger(event, this.value);"

  - To validate Decimal values.
    onKeyPress="return isDecimal(event, this.value, ',');"

Note: It is very useful to allow especial keys (such as Esc)
To do it you should use: isSpecialKey(event)
Eg: onKeyPress="return (isSpecialKey(event) || isInteger(event, this.value))"

*/




/*
* Ask if the value is an Integer
* @param the event
* @param the value to check
*/
function isInteger(e, value)
{
    //Vars
    var whichCode = (window.Event) ? e.which : e.keyCode;
    var inputValue = String.fromCharCode(whichCode);

    if (inputValue == sign)
    {
        if (isSignOk(value))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return integerRegExp.test(inputValue);
    }
}


/*
* Ask if the value is a Decimal
* @param the event
* @param the value to check
* @param the decimal separator
*/
function isDecimal(e, value, separator)
{
    //Vars
    var whichCode = (window.Event) ? e.which : e.keyCode;
    var inputValue = String.fromCharCode(whichCode);
    var isNumber = false
    var pointCount = 0;

    if (inputValue == sign)
    {
        if (isSignOk(value))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    else
    {
        if (integerRegExp.test(inputValue))
        {
            return true;
        }
        else
        {
            return (inputValue == separator && value.indexOf(inputValue) == -1);
        }
    }
}

/*
* Ask if the key event is special
* @param the event to check
*/
function isSpecialKey(e)
{
    //Vars
    var whichCode = (window.Event) ? e.which : e.keyCode;

    //Netscape special keys (bs=8, null=0)
    if (whichCode == 0 || whichCode == 8)
    {
        return true;
    }
    return false;
}

/*
* Ask if the key event is an Enter (Used to avoid form submition on enter actions)
* @param the event to check
*/
function isEnterKey(e)
{
    var keyCode = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;

    return keyCode == 13;
}

/*
* Checks that the value of the given field is a number with the given conditions:
* - intPres: The qty of allowed intergers
* - decimalPres: The qty of allowed decimals
* - decimalSeparator: The character used as decimal separator
*/
function checkNumber(field, intPres, decimalPres, decimalSeparator)
{
    var decimalRegExp = null;
    var theValue = field.value;

    if(theValue.indexOf(decimalSeparator) >= 0 && decimalPres > 0){
        decimalRegExp = RegExp("\^(\\+\|-)?\\d{0," + (intPres > 0?intPres :"") + "}\\" + decimalSeparator + "\\d{0," +
                               decimalPres + "}\$");
    }
    else {
        decimalRegExp = RegExp("\^(\\+\|-)?\\d{0," + (intPres > 0?intPres :"") + "}\$");
    }

    var isOk = decimalRegExp.test(theValue);
    if (!isOk) {
        theValue = decimalValues[field.name];
        if (theValue == null) {
            theValue = "";
        }
        field.value = theValue;
        return false;
    }
    else {
        decimalValues[field.name] = field.value;
        return true;
    }
}


/*******************************************************************************************************
* Value Validations Methods
********************************************************************************************************/

/*
* Ask if the value has a valid decimal precition
* @param the value to check
* @param the max presition
* @param the decimal separator
*/
function isPrecision(value, precision, separator)
{
    //Vars
    var indexPoint = value.indexOf(separator);

    if (indexPoint != -1)
    {
        var nextToPoint = value.substring(indexPoint + 1);
        if (nextToPoint.length >= precision)
        {
            return false;
        }
    }
    return true;
}

/*
* Ask if the value has a valid length
* @param the value to check
* @param the max length
*/
function isLength(value, len)
{
    if (len > value.length)
    {
        return true;
    }
    return false;
}

/*
* Ask if the value has the sign (-) in the rigth position 
* @param the value to check
*/
function isSignOk(value)
{
    //Vars
    var firstIndexOf = value.indexOf(sign);

    if (value != "")
    {
        return false;
    }
    if (firstIndexOf >= 0)
    {
        return false;
    }
    var secondIndexOf = value.lastIndexOf(sign);
    if (firstIndexOf != secondIndexOf)
    {
        return false;
    }
    return true;
}


/*
* Checks if the value is a valis email
* @param the value to check
*/
function isEmail(value)
{
    // checking for @ . or blank field
    if (value.indexOf(" ") != -1) {
        return false;
    }
    else if (value.indexOf("@") == -1) {
        return false;
    }
    else if (value.indexOf("@") == 0) {
        return false;
    }
    else if (value.substring(value.indexOf("@") + 2).indexOf(".") == -1) {
        return false;
    }
    else if (value.lastIndexOf("@") == value.length - 1) {
        return false;
    }
    else if (value.lastIndexOf(".") == value.length - 1) {
        return false;
    }
    return true;
}

function isBlank(value)
{
    if (value == null)
    {
        return true;
    }

    for (var i = 0; i < value.length; i++)
    {
        if ((value.charAt(i) != ' ') && (value.charAt(i) != "\t") && (value.charAt(i) != "\n") &&
            (value.charAt(i) != "\r"))
        {
            return false;
        }
    }
    return true;
}

/*
* Checks if the value matchs with input pattern
* @param the value
* @param the pattern to match (A RegExp Object)
*/
function isPatternMatch(value, pattern)
{
    //var pattern = strpattern;
    return isBlank(value) || pattern.test(value);
}

/*
* Checks if the value matchs with the date mask or if it is empty
* @param the value
* @param the date mask
*/
function isFObjectDate(value, mask, allowBlam)
{
    return (value == "" || isDate(value, mask));
}

/*
* Checks if the value matchs with the date mask
* @param the value
* @param the date mask
*/
function isDate(value, mask)
{
    var strMask = mask;
    var dayMask = strMask.lastIndexOf("d") - strMask.indexOf("d") + 1;
    var monthMask = strMask.lastIndexOf("m") - strMask.indexOf("m") + 1;
    var yearMask = strMask.lastIndexOf("y") - strMask.indexOf("y") + 1;

    var strDate = value;

    // find the delimiter
    var delim = "";
    var validChars = "mdy";
    for (var i = 0; i < strMask.length; i++)
    {
        if (validChars.indexOf(strMask.substring(i, i + 1)) == -1)
        {
            delim = strMask.substring(i, i + 1);
            break;
        }
    }

    aMask = strMask.split(delim);
    if (aMask.length == 3)
    {
        dt = value.split(delim);
        if (dt.length != 3) {
            return false;
        }
        for (i = 0; i < aMask.length; i++) {
            if (aMask[i].indexOf("m") > -1) var sMonth = dt[i];
            else if (aMask[i].indexOf("d") > -1) var sDay = dt[i];
            else if (aMask[i].indexOf("y") > -1) var sYear = dt[i];
        }
    }
    else if (mask.length == 1) {
        var sMonth = value.substring(strMask.indexOf("m") - 1, strMask.lastIndexOf("m"));
        var sDay = value.substring(strMask.indexOf("d") - 1, strMask.lastIndexOf("d"));
        var sYear = value.substring(strMask.indexOf("y") - 1, strMask.lastIndexOf("y"));
    }
    else {
        display("Invalid date mask was provided for this field.");
        return false;
    }

    var iMonth = parseInt(sMonth, 10);
    var iDay = parseInt(sDay, 10);
    var iYear = parseInt(sYear, 10);

    if (isNaN(iMonth) || sMonth.length > monthMask) {
        return false;
    }
    if (isNaN(iDay) || sDay.length > dayMask) {
        return false;
    }
    if (isNaN(sYear) || sYear.length != yearMask) {
        return false;
    }

    if (iDay < 1 || iDay > 31)
        return false;

    if (iMonth < 1 || iMonth > 12) {
        return false;
    }

    if (iYear < 100)
        iYear = iYear + ((iYear > 20) ? 1900 : 2000);

    if (iMonth == 2) {
        if (iDay > 29 || iDay == 29 && (iYear % 4 != 0 || iYear % 400 != 0))
            return false;
    }
    if (iDay > 30 && (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11)) {
        return false;
    }
    return true
}


/*******************************************************************************************************
* Perform-Validation methods
*******************************************************************************************************
To use performInlineValidation:

- You must put in an envent handler (inline):
performInlineValidation(eval('isPatternMatch(this.value, /^([^\.]*)$/)'),'The input does not match with the reg expr', '#FF0000', this)

Eg:
- OnChange event handler
onchange="performInlineValidation(eval('isPatternMatch(this.value, /^([^\.]*)$/)'),'The input does not match with the reg expr', '#FF0000', this)"

*/

/*
* This method shows an error if the given isValid is false
* @param isValid The error flag
* @param msg The error msg to show
* @param errorColor The error color. This color will be set to the background of the component
* @param component The component to apply the error action
*/
function performInlineValidation(isValid, msg, errorColor, component)
{
    return performInlineValidation(isValid, msg, errorColor, component, null, null);
}

/*
* This method shows an error if the given isValid is false
* @param isValid The error flag
* @param msg The error msg to show
* @param errorColor The error color. This color will be set to the background of the component
* @param component The component to apply the error action
* @param errorContainerNodeId The id of the error container area (The method sets/unset the display prop)
* @param errorTextNodeId The id of the element that will contain the error msg
*/
function performInlineValidation(isValid, msg, errorColor, component, errorContainerNodeId, errorTextNodeId)
{
    //Is there no current component or is this the current component?
    if (lastComponentName == "" || lastComponentName == component.name)
    {
        if (lastComponentName == "")
        {
            lastComponentName = component.name;
            lastComponentOriginalBgColor = component.style.backgroundColor;
            lastComponentFormOnSubmit = component.form.onsubmit;
        }

        //Debug
        //alert('performInlineValidation :: lastComponent :: [Name='+lastComponentName+'] [OriginalBgColor: '+lastComponentOriginalBgColor+']');


        if (!isValid)
        {
            //showing the error msg
            if (errorContainerNodeId == null || errorTextNodeId == null)
            {
                alert(msg);
            }
            else {
                var errorContainerNode = document.getElementById(errorContainerNodeId);
                var errorTextNode = document.getElementById(errorTextNodeId);

                if (errorContainerNode != null && errorTextNode != null)
                {
                    errorContainerNode.style.display = '';
                    showTextIn(errorTextNode, msg);
                }
                else {
                    alert(msg);
                }
            }

            //setting the error color
            component.style.backgroundColor = errorColor;

            //overriding the onblur event handler
            component.onblur = function()
            {
                component.focus();
                component.select();
                return false;
            };
            component.form.onsubmit = function()
            {
                component.focus();
                return isSubmitWithErrorsAllowed();
            };
            return false;
        }

        //Resetting values
        var backgroundColor = lastComponentOriginalBgColor;
        var onSubmitForm = lastComponentFormOnSubmit;

        component.onblur = function()
        {
        };

        component.style.backgroundColor = backgroundColor;
        lastComponentName = "";
        lastComponentOriginalBgColor = "";
        component.form.onsubmit = onSubmitForm;
        if (errorContainerNodeId != null)
        {
            var errorContainerNode = document.getElementById(errorContainerNodeId);
            if (errorContainerNode != null)
            {
                errorContainerNode.style.display = 'none';
            }
        }
        //Debug
        //alert('Reseting values ::: [component.style.backgroundColor : '+component.style.backgroundColor+']')

        return true;
    }
}

function showTextIn(textNode, text)
{
    if (textNode.hasChildNodes())
    {
        textNode.replaceChild(document.createTextNode(text), textNode.firstChild);
    }
    else {
        textNode.appendChild(document.createTextNode(text));
    }
}

/*
* Sets a flag to allow a submit with errors
*/
function allowSubmitWithErrors()
{
    isSubmitWithErrorAllowed = true;
}


/*
* Sets a flag to forbid a submit with errors
*/
function forbidSubmitWithErrors()
{
    isSubmitWithErrorAllowed = false;
}


/*
* isSubmitWithErrorsAllowed?
*/
function isSubmitWithErrorsAllowed()
{
    return isSubmitWithErrorAllowed;
}

/*
* isThereAnError?
*/
function isThereAnError()
{
    return (lastComponentName != "");
}

/*
* isSubmitAllowed?
*/
function isSubmitAllowed()
{
    return (isSubmitWithErrorsAllowed() || !isThereAnError());
}


/*******************************************************************************************************
* Selection Utils
********************************************************************************************************/

/*
* Sets the selected component
* @param the name of the component
*/
function setSelectedComponent(name)
{
    selectedComponent = name;
}

/*
* Unselected the selected component
* @param the event
*/
function unselect(e)
{
    //Vars
    var whichCode = (window.Event) ? e.which : e.keyCode;

    if (whichCode == 39 || whichCode == 37)
    {
        selectedComponent = ":)";
    }
}

/*
* Ask if a component is selected
* @param the name of the component
*/
function isSelected(name)
{
    //Vars
    var select = false;

    if (selectedComponent == name)
    {
        select = true;
    }

    selectedComponent = ":)";
    return select;
}
