var jsrsBrowser = jsrsBrowserSniff();
var jsrsMode = getRemoteScriptModeSupport();
var jsrsPOST = false;

//Error Messages
var remoteScriptNullResponseMsg = "The remote server is currently unavailable.\nThe portal might be experiencing technical difficulties.";
var remoteScriptNullRequest = "The request object could not be built.\nThe browser may not support XMLHttpRequest (remote scripting) technology.\nYou can disable it from your user options.";
var remoteScriptStatusProblem = "There was a problem retrieving the data";
/**
Sends a message to the given url
Return a string as response
*/
function execute(rsPage, parmNames, parms, isPost){

  // build URL to call //////////////////////////
  var URL = rsPage;
  var formEncodedParams = "";

  // always send context
  URL += "&C=" + this.id;
  
  // func and parms are optional
    if (parms != null){
        // assume parms is array of strings
        for( var i=0; i < parms.length; i++ ){
          if(i>0){
            formEncodedParams += "&";
          }
          formEncodedParams += parmNames[i] + "=" + myEncodeURIComponent(parms[i]+'');
        }
    } // parms

  // unique string to defeat cache
  var d = new Date();
  URL += "&U=" + d.getTime();
  ///////////////////////////////////////////////

  // Execute method
  var method = isPost ? "POST" : "GET";

  // Is Asyncronic?
  var isAsync = false;

  // Executing ...
  return executeURL(URL, formEncodedParams, method, isAsync);
}

/**
Calls the given URL with the given method mode and in the given sincronization way.
And returns the response of the URL if it is a syncronic execution, otherwise null is returned
*/
function executeURL(URL, formEncodedParams, method, isAsync){
    switch (jsrsMode) {
        case 'NATIVE':
          req = new XMLHttpRequest();
          if(req && (jsrsBrowser == "MOZ" || jsrsBrowser == "NS")){
            req.overrideMimeType("text/xml");
          }
          break;
        case 'ACTIVEX':
          req = new ActiveXObject("Msxml2.XMLHTTP");
          break;
    }

    var isSentOk = true;

    if(req){
        //Open
        req.open(method, URL, isAsync);
        //Setting content-type
        req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        //Setting content-length
        req.setRequestHeader("Content-Length", formEncodedParams.length);
        //Sending
        try{
            req.send(formEncodedParams);
        }catch(e){
            //Sync executions throw an exception when the server is down
            isSentOk = false;
        }
    } else {
        //The request could not be built, the browser may not support XMLHttpRequest Object
        showExecutionErrorMessage(remoteScriptNullRequest);
    }

    var response = null;

    if(isSentOk){
        if(!isAsync && req){
            if(req.readyState == 4){
                if(req.status == 200){
                    //Successful execution
                    response = req.responseText;
                    if(response != null){
                        //Removing XML Header
                        var headerCloseIndex = response.indexOf("?>");
                        if(headerCloseIndex != -1){
                            var responseStartIndex = response.indexOf("<", headerCloseIndex);
                            response = response.substring(responseStartIndex);
                        }
                    }
                }else{
                    //Problem
                    showExecutionErrorMessage(remoteScriptNullResponseMsg + "\n[Error: "+req.status+"]");
                }
            }
        }
    }else{
        showExecutionErrorMessage(remoteScriptNullResponseMsg);
    }

    return response;
}

function jsrsEscapeQQ( thing ){
  if(thing != null && typeof(thing) == "string"){
    return thing.replace(/'"'/g, '\\"');
  }

  return "";
}

function jsrsUnescape( str ){
  return str.replace( /\\\//g, "/" );
}

function jsrsBrowserSniff(){
  if (document.layers) return "NS";
  if (document.all) {
		var agt=navigator.userAgent.toLowerCase();

		var is_konq = (agt.indexOf("konqueror") != -1);
      var is_opera = (agt.indexOf("opera") != -1);
        if(is_opera) {
			return "OPR";
		} else {
            if (!is_konq) {
                // Really is IE
                return "IE";
            } else {
                return "KONQ";
            }
        }
  }
  if (document.getElementById) {
      var agt = navigator.userAgent.toLowerCase();
      var is_safari = (agt.indexOf("safari") != -1);
      if (!is_safari) {
          return "MOZ";
      } else {
          return "SAF";
      }
  }
  return "OTHER";
}

/////////////////////////////////////////////////
//
// user functions

function jsrsArrayFromString( s, delim ){
  var d = (delim == null)? '~' : delim;
  return s.split(d);
}

function getRemoteScriptModeSupport()
{
	try{
		if(window.XMLHttpRequest)
		{
			return "NATIVE";
		}
		else if(window.ActiveXObject)
		{
			return "ACTIVEX";
		}
		else
		{
			return "NONE";
		}

	}catch(e){return "NONE";}
}

function isRemoteScriptSupported()
{
    return (jsrsMode == "NATIVE" || jsrsMode == "ACTIVEX");
}

function myEncodeURIComponent(component)
{
    var encondedComponent = "";
    if(component != null && component.length > 0){
        if (typeof encodeURIComponent == "function")
        {
            //JavaScript 1.5
            // Netscape 6+, Mozilla and IE 5.5+
            encondedComponent = encodeURIComponent(component);
        } else {
            // IE 4, IE 5.0 and Netscape 4
            encondedComponent = encodeURIComponentOld(component);
        }
    }else{
        encondedComponent = component;
    }
    return encondedComponent;
}

function encodeURIComponentOld(component) {
    var uricharset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
    var utf8Component = convertToUTF8(component);
    var encodedComponent = "";
    for (var i= 0; i<utf8Component.length; i++)
    {
        if (uricharset.indexOf(utf8Component.charAt(i)) != -1){
            encodedComponent += utf8Component.charAt(i);
        }else{
            //Not in URI charset
            encodedComponent += "%" + convertToHex(utf8Component.charCodeAt(i));
        }
    }
    return encodedComponent;
}

function convertToUTF8(theText) {
    theText = theText.replace(/\r\n/g,"\n");
    var utftext = "";
    for(var n=0; n<theText.length; n++)
    {
        var c = theText.charCodeAt(n);
        // All between 0-127 = 1byte
        if (c<128){
            utftext += String.fromCharCode(c);
        } else if((c>127) && (c<2048)) {
            //All between 127 and 2047 = 2bytes
            utftext += String.fromCharCode((c>>6)|192);
            utftext += String.fromCharCode((c&63)|128);
        } else {
            // All between 2048 and 66536 = 3bytes
            utftext += String.fromCharCode((c>>12)|224);
            utftext += String.fromCharCode(((c>>6)&63)|128);
            utftext += String.fromCharCode((c&63)|128);
        }
    }
    return utftext;
}

function convertToHex(n) {
    var hexCharset = "0123456789ABCDEF";
    return hexCharset.charAt(n>>4) + hexCharset.charAt(n & 0xF);
}

