/******************************************************************************
 Fuego JS: Mask library

 Needs: Fuego Validation library

 Author: Nicolas Damonte
 Build:  1.00
******************************************************************************/

var num = '#';
var upperCaseAlpha = 'U';
var lowerCaseAlpha = 'L';
var alpha = '?';
var alphaNum = 'A';
var any = '*';
var escapeChar = '\'';

var numRegExp = /^([0-9]*)$/;
var alphaRegExp = /^([a-zA-Z]*)$/;
var alphaNumRegExp = /^([a-zA-Z0-9]*)$/;

/**
* Apply the given mask to the given textfield component.
* It returns true if the operation is successfull or if the value is blank, otherwise false
* @param theMask the mask to apply
* @param the mask target component
*
* Eg:
* onchange="applyMask('(54-11)####-####', this)"
*/
function applyMask(theMask, component)
{
	withoutMaskValue = component.value;

	if(isBlank(withoutMaskValue))
	{
		withMaskValue = '';
	}
	else
	{
	    withMaskValue = new String();
	    indexOfValue  = -1;

	    hasMaskTheValue = false;

	    if(withoutMaskValue.length >= getMaskLength(theMask))
	    {
		    hasMaskTheValue = true;
	    }

	    for(i = 0; i < theMask.length; i++)
	    {
		    theMaskChar = theMask.charAt(i);

		    switch(theMaskChar)
		    {
			    case num:
			    case upperCaseAlpha:
			    case lowerCaseAlpha:
			    case alpha:
			    case alphaNum:
			    case any:
				    indexOfValue++;
				    if(indexOfValue >= withoutMaskValue.length)
				    {
					    //The input value does not contain enough characters to match the mask
					    return false;
				    }
				    character = withoutMaskValue.charAt(indexOfValue);

				    //Non special characters /////////////////////////////////////////////

				    //debug
				    //alert("[i="+i+"] [index="+indexOfValue+"] [character=" + character + "] [maskChar="+theMaskChar+"]");

				    //Does the character match the mask?
				    if(testCharacter(theMaskChar, character))
				    {
					    withMaskValue = withMaskValue.concat(tranformCharacter(theMaskChar, character));
				    }
				    else
				    {
					    //alert("The character does not match with the mask");
					    //The character does not match with the mask
					    return false;
				    }
				    break;

			    case escapeChar:
				    //'U
				    if(i+1 < theMask.length)
				    {
					    withMaskValue = withMaskValue.concat(theMask.charAt(++i));
					    if(hasMaskTheValue)
					    {
						    if(withoutMaskValue.charAt(indexOfValue+1) == theMask.charAt(i))
						    {
							    indexOfValue++;
						    }
					    }
				    }
				    else
				    {
					    return false;
				    }

				    break;

			    default:
				    //Special characters /////////////////////////////////////////////////
				    withMaskValue = withMaskValue.concat(theMaskChar);
				    if(hasMaskTheValue)
				    {
					    if(theMaskChar == withoutMaskValue.charAt(indexOfValue+1))
					    {
						    indexOfValue++;
					    }
				    }

				    break;
		    }
	    }
	}

	component.value = withMaskValue;
	return true;
}

function testCharacter(maskCharacter, character)
{
	switch(maskCharacter)
	{
		case num:
			return numRegExp.test(character);

		case upperCaseAlpha:
		case lowerCaseAlpha:
		case alpha:
			return alphaRegExp.test(character);

		case alphaNum:
			return alphaNumRegExp.test(character);

		case any:
			return true;

		default:
			return false;
	}
}

function tranformCharacter(maskCharacter, character)
{
	switch(maskCharacter)
	{
		case upperCaseAlpha:
			return character.toUpperCase();

		case lowerCaseAlpha:
			return character.toLowerCase();

		case num:
		case alpha:
		case alphaNum:
		case any:
		default:
			return character;
	}
}

/**
* Lenght of the mask without escape characters.
*/
function getMaskLength(mask)
{
	//debug
	//alert("[mask.length: " + mask.length + "] [(mask.split(escapeChar).length - 1) : "+ (mask.split(escapeChar).length - 1) + "]");
	return mask.length - (mask.split(escapeChar).length - 1);
}

/**
* Removes the mask from the given value and returns the clean value
* If the operation is not success the method returns null
*/
function cleanMask(theMask, value)
{
	//Value to return (without mask)
	withoutMaskValue = new String();
	//Value to transform (with mask)
	withMaskValue = value;

	//The clean is performed only if the mask length (without escape chars) is equals the value with mask length
	if(getMaskLength(theMask) != withMaskValue.length)
	{
		return null;
	}

	//Iter the mask
	indexOfValueWithMask = -1;

	for(i = 0; i < theMask.length; i++)
	{
		theMaskChar = theMask.charAt(i);

		switch(theMaskChar)
		{
			case num:
			case upperCaseAlpha:
			case lowerCaseAlpha:
			case alpha:
			case alphaNum:
			case any:
				indexOfValueWithMask++;
				character = withMaskValue.charAt(indexOfValueWithMask);

				if(!testCharacter(theMaskChar, character))
				{
					return null;
				}

				//debug
				//alert("[maskIndex="+i+"] [valueIndex="+indexOfValueWithMask+"] [character=" + character + "] [maskChar="+theMaskChar+"]");

				withoutMaskValue = withoutMaskValue.concat(character);
				break;

			case escapeChar:
				i++;

			default:
				indexOfValueWithMask++;
				break;
		}
	}

	return withoutMaskValue;
}

/**
* Removes the mask from the given component value.
* Returns true if the operation is success otherwise it returns false
*/
function cleanComponentMask(theMask, component)
{
	if(isBlank(component.value))
	{
		withoutMaskValue = '';
	}
	else
	{
		withoutMaskValue = cleanMask(theMask, component.value);
	}

	if(withoutMaskValue != null)
	{
		component.value = withoutMaskValue;
		return true;
	}
	else
	{
		return false;
	}
}