/******************************************************************************
 Fuego JS: XO Group

 Author: Nicolas Damonte
 Build:  1.00
******************************************************************************/

var groupMap = new Array();

function resetGroupMap()
{
	groupMap = new Array();
}

/*
* Highlight the TR of the given trId of the given group
*/
function highlightTR(trId, groupName)
{
	//True if the TR has not been already selected, otherwise false
	var isSelection = true;

	//Logic
	if(groupMap[groupName] == null)
	{
		groupMap[groupName] = new Array();
		groupSelectedTRsMap = groupMap[groupName];

		//show toolbar
		performToolbarShow(groupName, true);
	}

	var trSelectedIndex = -1;
	var itemCount = 0;
	var groupSelectedTRsMapBackup = new Array();

	for(i=0; i<groupMap[groupName].length; i++)
	{
		if(groupMap[groupName][i] == trId)
		{
			trSelectedIndex = i;
		}else{
			groupSelectedTRsMapBackup[itemCount++] = groupMap[groupName][i];
		}
	}

	if(trSelectedIndex == -1)
	{
		//The TR is not selected
		isSelection = true;

		groupMap[groupName][groupMap[groupName].length] = trId;


	}else{
		//The TR has been already selected
		isSelection = false;

		groupMap[groupName] = groupSelectedTRsMapBackup.length>0?groupSelectedTRsMapBackup:null;

		if(groupMap[groupName]==null)
		{
			//hideToolBar
			performToolbarShow(groupName, false)
		}
	}

	//Toggle Presentation TR
	performTrPresentationHighlight(trId, isSelection);
}


/*
* Private ::: Highlight the TR of the given trId
*/
function performTrPresentationHighlight(trId, isSelection)
{
	//Getting TR of the given trId
	var tr = document.getElementById(trId);

	if(tr != null && tr.hasChildNodes())
	{
		//Getting its cells
		var tds = tr.cells;

		for(i=1; i<tds.length; i++)
		{
			var td = tds[i];

			bgColor = td.style.backgroundColor;
			fgColor = td.style.color;

			if(bgColor == "")
			{
				bgColor = "rgb(255,255,255)";
			} else {
				if(bgColor.indexOf("rgb") != -1)
				{
					bgColor = "";
				}
			}

			if(fgColor == "")
			{
				fgColor = "rgb(0,0,0)";
			} else {

				if(fgColor.indexOf("rgb") != -1)
				{
					fgColor = "";
				}
			}

			td.style.backgroundColor = fgColor;
			td.style.color = bgColor;
		}
	}
}

/*
* Perform
*/
function performToolbarShow(groupName, isRowSelected)
{
	//Select toolbar stuff
	addUp = document.getElementById(groupName + '$addUpDIV');
	addUp.style.display=isRowSelected?'':'none';

	addUp = document.getElementById(groupName + '$addUpDisabledDIV');
	addUp.style.display=isRowSelected?'none':'';

	addDown = document.getElementById(groupName + '$addDownDIV');
	addDown.style.display=isRowSelected?'':'none';

	addDown = document.getElementById(groupName + '$addDownDisabledDIV');
	addDown.style.display=isRowSelected?'none':'';

	remove = document.getElementById(groupName + '$removeDIV');
	remove.style.display=isRowSelected?'':'none';

	remove = document.getElementById(groupName + '$removeDisabledDIV');
	remove.style.display=isRowSelected?'none':'';

	//Gral toolbar stuff
	add = document.getElementById(groupName + '$addDIV');
	add.style.display=isRowSelected?'none':'';

	add = document.getElementById(groupName + '$addDisabledDIV');
	add.style.display=isRowSelected?'':'none';

	minus = document.getElementById(groupName + '$minusDIV');
	minus.style.display=isRowSelected?'none':'';

	minus = document.getElementById(groupName + '$minusDisabledDIV');
	minus.style.display=isRowSelected?'':'none';
}


/*
* Has highlighted rows?
*/
function hasHighLightedRows(groupName)
{
	return (getHighLightRowIndexes(groupName).length > 0);
}

/*
* Returns an array of indexes of the selected rows of the given groupName
*/
function getHighLightRowIndexes(groupName)
{
	var indexes = new Array();

	if(groupMap[groupName] != null)
	{
		for(i=0; i<groupMap[groupName].length; i++)
		{
			var trId = groupMap[groupName][i];

			var rowFirstIndex = trId.lastIndexOf("[");
			var rowLastIndex = trId.lastIndexOf("]");

			indexes[i] = trId.substring(rowFirstIndex + 1, rowLastIndex);

			//alert('indexes[i] --->>> '+indexes[i])
		}
	}

	//alert('indexes.length --->>> ' + indexes.length);

	return indexes.sort(function(a,b){return a-b;});
}

/*
* Returns lowest index selection
*/
function getLowestIndexSelection(groupName)
{
	firstSelection = null;

	indexes = getHighLightRowIndexes(groupName);

	if(indexes.length > 0)
	{
		firstSelection = indexes[0];
	}

	return firstSelection;
}

/*
* Returns highest index selection
*/
function getHighestIndexSelection(groupName)
{
	firstSelection = null;

	indexes = getHighLightRowIndexes(groupName);

	if(indexes.length > 0)
	{
		firstSelection = indexes[indexes.length - 1];
	}

	return firstSelection;
}

/*
* Returns an string with all the selected rows of every group
*/
function groupHighLightToString()
{
	var str = "";

	for(var x in groupMap)
	{
		var selectedRowIndexes = getHighLightRowIndexes(x);

		if(selectedRowIndexes != null && selectedRowIndexes.length > 0)
		{
			str = str.concat(x + '@' + selectedRowIndexes.toString() + ';');
		}
	}

	//alert(str);

	return str;
}