<%--
	Copyright (c) 2000 Fuego Inc. All Rights Reserved
	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF eTopware Inc.
	The copyright notice above does not evidence any actual or intended
	publication of such source code.

	$Id: webXOFileChooser.jsp 98817 2009-06-04 12:01:54Z diegor $
--%>
<%@ page
    session="true"
    import="java.util.*, oracle.bpm.xobject.runtime.*"
    language="java" 
    contentType="text/html;charset=UTF-8"
%>
<%@ page import="oracle.bpm.web.execution.ExternalContext"%>
<%@ page import="oracle.bpm.web.execution.ComponentContext"%>
<%@ page import="oracle.bpm.web.execution.impl.WebUtils"%>
<%@ page import="oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg"%>
<%
    final ExternalContext externalContext = WebUtils.createExternalContext(request, response);
    ComponentContext invocation = null;
    String docKey                = null;
    String screenKey             = null;
    Locale locale = Locale.getDefault();

    try{


        invocation   = WebUtils.findComponentContext(externalContext);
        locale = invocation.getLocale();
        docKey       = (String) invocation.getAttribute(XOConstants.XCONTROLLER_ID_PARAM_NAME);
        screenKey    = (String) invocation.getAttribute(XOConstants.XSCREEN_ID_PARAM_NAME);

    } catch(Throwable t){/**Safe to ignore**/}

    String dataId       = ((String)request.getAttribute(XOConstants.FILE_CHOOSER_DATAID_PARAM_NAME));
    String result       = ((String)request.getAttribute(XOConstants.FILE_CHOOSER_RESULT_PARAM_NAME));
    String onChange     = ((String)request.getAttribute(XOConstants.FILE_CHOOSER_ONCHANGE_PARAM_NAME));

    String formUrl      = WebUtils.urlForAction("XObject", "fileChooserManager", externalContext);//request.getContextPath() + "/servlet/fofilechooser";

    String bodyOnLoadScript = null;
    if(result == null){
        bodyOnLoadScript = "";
    } else {
        int resultCode = Integer.parseInt(result);
        switch (resultCode){
            case XOConstants.FILE_CHOOSER_RESULT_OK:
                if (onChange != null) {
                    bodyOnLoadScript = "window.opener.refreshImageOnChange('" + onChange + "');self.close()";
                }
                else {
                    bodyOnLoadScript = "window.opener.refreshImage();self.close()";
                }
                break;
            case XOConstants.FILE_CHOOSER_RESULT_ERROR:
                bodyOnLoadScript = "self.close()";
                break;
            default:
                bodyOnLoadScript = "";
        }
    }
%>
<HTML>
<head>
<title><%=WebUtils.getTitle(externalContext)%></title>
<link rel="stylesheet" type="text/css" href="<%=WebUtils.getStyleSheet(externalContext)%>">
<link rel="shortcut icon" type="image/x-icon" href="<%=WebUtils.urlForStaticImage("Application", "LOGO_ICO",externalContext)%>">
<link rel="icon" type="image/x-icon" href="<%=WebUtils.urlForStaticImage("Application","LOGO_ICO",externalContext)%>">
</head>
<script language="javascript">
window.name = "fofilechooser";

var validFilenames = [".jpg", ".jpeg", ".png", ".gif"];
var errorMsg = "<%=XObjectRuntimeMsg.NON_SUPPORTED_FILENAME("jpg, jpeg, png, gif").getString(locale)%>";

function checkImageFileName(filename){
    if(filename != null && filename != "") {
        for(vvIndex=0; vvIndex < validFilenames.length; vvIndex++){
            if(filename.match(new RegExp(validFilenames[vvIndex] + "$", "i"))){
                return true;
            }
        }

        alert(errorMsg);
        return false;
    }
    return true;
}
</script>
<BODY MARGINWIDTH=0 MARGINHEIGHT=0 TOPMARGIN=0 RIGHTMARGIN=0 LEFTMARGIN=0 onload="<%=bodyOnLoadScript%>">
<FORM method="POST" action="<%=formUrl%>" enctype="multipart/form-data" name="foFileChooserForm" id="foFileChooserForm">
<INPUT TYPE="hidden" name="<%=XOConstants.ACTION_PARAM_NAME%>" value="<%=XOConstants.FILE_CHOOSER_ACTION_APPLY%>">
<INPUT TYPE="hidden" name="<%=XOConstants.XCONTROLLER_ID_PARAM_NAME%>" value="<%=docKey%>">
<INPUT TYPE="hidden" name="<%=XOConstants.XSCREEN_ID_PARAM_NAME%>" value="<%=screenKey%>">
<INPUT TYPE="hidden" name="<%=XOConstants.FILE_CHOOSER_DATAID_PARAM_NAME%>" value="<%=dataId%>">
<% if (onChange != null) {%>
<INPUT TYPE="hidden" name="<%=XOConstants.FILE_CHOOSER_ONCHANGE_PARAM_NAME%>" value="<%=onChange%>">
<% } %>

<CENTER>
<TABLE HEIGTH="100%" WIDTH="100%" BORDER="0" BORDERWIDTH="0" CELLSPACING="0" CELLPADDING="2">
<TR>
    <TD class="txtblack"><%=XObjectRuntimeMsg.FILENAME.getString(locale)%></TD>
    <TD><INPUT TYPE="file" id="<%=dataId%>" name="<%=dataId%>"></TD>
</TR>
<TR>
    <TD colspan=2 align="center">
        <TABLE>
        <TR>
            <TD><INPUT type="submit" name="<%=XObjectRuntimeMsg.OK.getString(locale)%>" value="<%=XObjectRuntimeMsg.OK.getString(locale)%>" onclick="return checkImageFileName(document.getElementById('<%=dataId%>').value);"></TD>
            <TD><INPUT type="button" name="<%=XObjectRuntimeMsg.CLOSE.getString(locale)%>" value="<%=XObjectRuntimeMsg.CLOSE.getString(locale)%>" onClick="self.close();return false;"></TD>
        </TR>
        </TABLE>
    </TD>
</TR>
</TABLE>
</CENTER>
</FORM>
</BODY>
</HTML>
