/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.builder;

import oracle.bpm.cil.CilCompiler;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.fusion.builder.BuildProblems;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compiler.CompilationOptions;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ProgressMonitor;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.jdeveloper.compiler.JCompiler;

public class BpmBuilder {
    private Context currentContext;
    private oracle.bpm.project.model.Project currentProject;

    public BuildProblems build(Context context) {
        this.currentContext = context;
        oracle.bpm.project.model.Project project = this.extractProject(context);
        boolean deploying = context.containsProperty("oracle.tip.tools.ide.fabric.deploy.common.SOADeployerConfigObject");
        this.currentProject = project;
        BuildProblems problems = new BuildProblems(project);
        if (project != null) {
            this.buildProject(project, problems, deploying);
        }
        return problems;
    }

    public void clean(Context context) {
    }

    private void buildProject(oracle.bpm.project.model.Project project, BuildProblems problems, boolean deploying) {
        ProjectCompiler compiler = ProjectCompiler.createDefault((oracle.bpm.project.model.Project)project);
        if (this.isBusinessAnalyst()) {
            compiler.setOptions(new CheckOptions(12803));
        }
        CompilationOptions options = new CompilationOptions();
        options.setFullBuild(true);
        options.setDeploying(deploying);
        compiler.setCatalogCompiler((CilCompiler)this.createFuegoCompiler(project));
        CompilationListener listener = new CompilationListener(problems);
        compiler.addCompilationListener((ProjectCompilationListener)listener);
        compiler.compile(this.createMonitor(), options);
    }

    private boolean isBusinessAnalyst() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        return Ide.getProductID().equals("oracle.bpm.fusion.studio") || extensionRegistry.getRoleManager().getActiveRole().getId().equals("oracle.bpm.role");
    }

    private oracle.bpm.project.model.Project extractProject(Context context) {
        Project devProject = context.getProject();
        if (devProject != null) {
            return JdevRepositoryService.getInstance().getProject(devProject);
        }
        return null;
    }

    private FuegoCompiler createFuegoCompiler(oracle.bpm.project.model.Project bpmProject) {
        return new FuegoCompiler();
    }

    private ProgressMonitor createMonitor() {
        return new ProgressMonitorImpl();
    }

    private class CompilationListener
    implements ProjectCompilationListener {
        private BuildProblems problems;

        private CompilationListener(BuildProblems problems) {
            this.problems = problems;
        }

        public void onError(ProjectException exception) {
            this.problems.onError(exception);
        }

        public void onWarning(ProjectException exception) {
            this.problems.onWarning(exception);
        }

        public void onInfo(ProjectException exception) {
        }

        public void onCheckStarted(ProjectObject projectObject) {
        }

        public void onCheckFinished(ProjectObject projectObject) {
        }

        public boolean onInterruptionCheck() {
            return false;
        }
    }

    private static class ProgressMonitorImpl
    implements ProgressMonitor {
        private LogPage outputLog = JCompiler.getCompiler().getOutputLog();

        private ProgressMonitorImpl() {
        }

        @Override
        public void error(Msg message) {
        }

        @Override
        public void info(Msg message) {
        }

        @Override
        public void info(int logLevel, Msg message) {
        }

        @Override
        public void phase(Msg message) {
            this.outputLog.log((Object)(message.getString() + "\n"));
        }

        @Override
        public void progress(int percent) {
        }

        @Override
        public void warning(Msg message) {
            this.outputLog.log((Object)(message.getString() + "\n"));
        }
    }
}

