/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.interfaces;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.interfaces.ProcessOperationWrapperImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.MessageEventDefinition;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ThrowEvent;
import org.jetbrains.annotations.NotNull;

public class ProcessUtil {
    public static ProjectErrorQNames getProjectErrorQNames(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessUtil.getProjectErrorQNames must not be null");
        }
        return new ProjectErrorQNames(project);
    }

    private static Map<String, Set<QName>> loadErrorQNames(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessUtil.loadErrorQNames must not be null");
        }
        HashMap<String, Set<QName>> errorQNames = new HashMap<String, Set<QName>>();
        Collection<Process> processes = project.getProcesses();
        for (Process process : processes) {
            Sequence<ThrowEvent> throwEventSequence = process.getDescendants(ThrowEvent.class);
            for (ThrowEvent throwEvent : throwEventSequence) {
                ErrorEventDefinition errorEventDefinition = null;
                EventDefinition definition = throwEvent.getEventDefinition();
                if (definition != null) {
                    if (throwEvent.getEventTriggerType() == EventTriggerType.MESSAGE) {
                        MessageEventDefinition messageEventDefinition = definition.as(MessageEventDefinition.class);
                        ProcessOperationWrapperImpl x = new ProcessOperationWrapperImpl(throwEvent);
                        boolean definer = x.isServiceDefiner();
                        if (throwEvent.isSync() && definer && messageEventDefinition.returnsErrors()) {
                            errorEventDefinition = messageEventDefinition.getErrorEventDefinition();
                        }
                    } else if (throwEvent.getEventTriggerType() == EventTriggerType.ERROR) {
                        errorEventDefinition = definition.as(ErrorEventDefinition.class);
                    }
                }
                if (errorEventDefinition == null || errorEventDefinition.getError() == null) continue;
                String errorName = errorEventDefinition.getError().getName();
                HashSet<QName> set = (HashSet<QName>)errorQNames.get(errorName);
                if (set == null) {
                    set = new HashSet<QName>();
                    errorQNames.put(errorName, set);
                }
                set.add(new QName(process.getNamespace(), errorName));
            }
        }
        return errorQNames;
    }

    public static class ProjectErrorQNames {
        @NotNull
        private final Project project;
        private Map<String, Set<QName>> qNamesByErrorName;

        private ProjectErrorQNames(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessUtil$ProjectErrorQNames.<init> must not be null");
            }
            this.project = project;
        }

        public Set<QName> getErrorQNames(@NotNull ErrorObject errorObject) {
            if (errorObject == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/interfaces/ProcessUtil$ProjectErrorQNames.getErrorQNames must not be null");
            }
            Set<QName> result = errorObject.isErrorDefinedExternally() ? Collections.singleton(errorObject.getErrorCode()) : this.getQNamesByErrorName().get(errorObject.getName());
            return result == null ? Collections.emptySet() : result;
        }

        private Map<String, Set<QName>> getQNamesByErrorName() {
            if (this.qNamesByErrorName == null) {
                this.qNamesByErrorName = ProcessUtil.loadErrorQNames(this.project);
            }
            return this.qNamesByErrorName;
        }
    }
}

