/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.xmltype;

import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.FaultUUID;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeUUID;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTypeHelper {
    private static final char SIGNATURE_SEPARATOR = ';';
    private static final String XMLOBJECT_NAME = "XMLObject";
    private static final String XML_TEXT = "xmlText";
    private static final String NAME = "name";
    private static final String ATTRIBUTES = "attributes";
    public static final ObjectTypeDescription XMLOBJECT = XmlTypeHelper.createNewOTD("XMLObject");
    public static final String XML_SCHEMA = "xmlschema";

    private XmlTypeHelper() {
    }

    public static String buildSignature(String name, String namespace, boolean elementsAreQualified, boolean attrsAreQualified) {
        StringBuilder signature = new StringBuilder(name);
        signature.append(';').append(namespace);
        signature.append(';').append(elementsAreQualified ? "elementsQualified" : "N");
        signature.append(';').append(attrsAreQualified ? "attributesQualified" : "N");
        return signature.toString();
    }

    public static XmlTypeDescription createXmlTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String location, boolean elementsAreQualified, boolean attrsAreQualified, @NotNull XmlElementType xmlElementType) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescription must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescription must not be null");
        }
        if (xmlElementType == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescription must not be null");
        }
        XmlTypeDescription xmlOtd = XmlTypeDescription.createForExternalXml((String)name, (String)namespace, (String)location, (XmlElementType)xmlElementType);
        return XmlTypeHelper.loadXmlObjectTypeDescription(xmlOtd, name, elementsAreQualified, attrsAreQualified);
    }

    public static XmlTypeDescription createXmlTypeDescriptionForFault(@NotNull String name, @NotNull String namespace, @Nullable String location, @NotNull String msgNamespace, @NotNull String msgName) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescriptionForFault must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescriptionForFault must not be null");
        }
        if (msgNamespace == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescriptionForFault must not be null");
        }
        if (msgName == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/project/catalog/xmltype/XmlTypeHelper.createXmlTypeDescriptionForFault must not be null");
        }
        FaultUUID faultId = UUIDFactory.createFaultId((String)namespace, (String)name, (String)msgNamespace, (String)msgName);
        XmlTypeDescription xmlOtd = XmlTypeDescription.createForExternalXml((String)name, (String)namespace, (String)location, (XmlElementType)XmlElementType.FAULT, (TypeUUID)faultId);
        return XmlTypeHelper.loadXmlObjectTypeDescription(xmlOtd, name, false, false);
    }

    public static void addElementTypeInfo(ObjectTypeDescription object, String name, String namespace, TypeRef ref) {
        String typeId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.TYPE, (String)namespace, (String)name).getId();
        object.setProperty("element.type.id", typeId);
        object.removeAllSuperTypes();
        object.addSuperType(new SuperType(ref, 0x800000L));
    }

    static ObjectTypeDescription createNewOTD(String name) {
        ObjectTypeDescription otd = new ObjectTypeDescription(Identifier.classname(name));
        otd.setNativeName(name);
        otd.setModifiers(otd.getModifiers() | 0x10000000L);
        otd.setLocalEnabled(true);
        otd.setComponentType(ComponentType.XML.getText());
        otd.setProperty("invokeableClassName", "oracle.bpm.bpmobject.runtime.XMLObject");
        return otd;
    }

    private static XmlTypeDescription loadXmlObjectTypeDescription(XmlTypeDescription objType, String name, boolean elementsAreQualified, boolean attrsAreQualified) {
        String namespace = objType.getNamespace();
        String signature = XmlTypeHelper.buildSignature(name, namespace, elementsAreQualified, attrsAreQualified);
        name = Identifier.classname(name);
        objType.setSignature(signature);
        XmlTypeHelper.addConstructors((ObjectTypeDescription)objType, name, signature);
        XmlTypeHelper.resolveSuperTypes((ObjectTypeDescription)objType, name);
        objType.setElementsAreQualified(elementsAreQualified);
        objType.setAttributesAreQualified(attrsAreQualified);
        return objType;
    }

    private static void resolveSuperTypes(ObjectTypeDescription objType, String name) {
        if (XMLOBJECT_NAME.equals(name)) {
            objType.setSuperTypes(SuperType.getAnySuperTypeList());
            XmlTypeHelper.loadMemberForBaseType(objType);
        } else {
            SuperType sclass = new SuperType((TypeRef)XMLOBJECT, 0x2000000L);
            objType.setSuperTypes(new SuperType[]{sclass});
        }
    }

    private static void addConstructors(ObjectTypeDescription objType, String name, String signature) {
        MethodTypeDescription defConstructor = XmlTypeHelper.addDefaultConstructor(objType, name, signature);
        MethodTypeDescription mapConstructor = XmlTypeHelper.addConstructorFromAssociativeArray(objType, name, signature);
        MethodTypeDescription xmlConstructor = XmlTypeHelper.addConstructorFromXmlText(objType, name, signature);
        defConstructor.setModifiers(0x2000000L);
        mapConstructor.setModifiers(0x2000000L);
        xmlConstructor.setModifiers(0x2000000L);
        objType.addMember(defConstructor);
        objType.addMember(mapConstructor);
        objType.addMember(xmlConstructor);
    }

    private static MethodTypeDescription addConstructorFromXmlText(ObjectTypeDescription objType, String name, String signature) {
        MethodTypeDescription xmlConstructor = new MethodTypeDescription(name);
        xmlConstructor.setResultType((TypeRef)objType);
        xmlConstructor.setSignature('X' + signature);
        xmlConstructor.addArgument(new Argument(XML_TEXT, (TypeRef)TypeFactory.getString(), 1L));
        xmlConstructor.setModifiers(32832L);
        return xmlConstructor;
    }

    private static MethodTypeDescription addConstructorFromAssociativeArray(ObjectTypeDescription objType, String name, String signature) {
        MethodTypeDescription mapConstructor = new MethodTypeDescription(name);
        mapConstructor.setResultType((TypeRef)objType);
        mapConstructor.setSignature('F' + signature);
        mapConstructor.setModifiers(33587264L);
        mapConstructor.addArgument(new Argument(NAME, (TypeRef)TypeFactory.getString(), 1L));
        mapConstructor.addArgument(new Argument(ATTRIBUTES, (TypeRef)TypeFactory.getMap((TypeRef)TypeFactory.getString(), (TypeRef)TypeFactory.getString()), 1L));
        return mapConstructor;
    }

    private static MethodTypeDescription addDefaultConstructor(ObjectTypeDescription objType, String name, String signature) {
        MethodTypeDescription defConstructor = new MethodTypeDescription(name);
        defConstructor.setResultType((TypeRef)objType);
        defConstructor.setSignature('D' + signature);
        defConstructor.setModifiers(33587264L);
        return defConstructor;
    }

    private static void loadXmlObject(String name, String namespace, boolean elementsAreQualified, boolean attrsAreQualified) {
        String signature = XmlTypeHelper.buildSignature(name, namespace, elementsAreQualified, attrsAreQualified);
        name = Identifier.classname(name);
        ObjectTypeDescription xmlObj = XMLOBJECT;
        xmlObj.setSignature(signature);
        XmlTypeHelper.addConstructors(xmlObj, name, signature);
        XmlTypeHelper.resolveSuperTypes(xmlObj, name);
    }

    private static void loadMemberForBaseType(ObjectTypeDescription objType) {
        ArrayTypeDescription children = TypeFactory.getArray((TypeRef)XMLOBJECT);
        AttributeTypeDescription attribute = new AttributeTypeDescription(ATTRIBUTES, (TypeRef)TypeFactory.getMap((TypeRef)TypeFactory.getString(), (TypeRef)TypeFactory.getString()));
        attribute.setReadSignature(String.valueOf('M'));
        attribute.setWriteSignature(String.valueOf('M'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        attribute = new AttributeTypeDescription("children", (TypeRef)children);
        attribute.setReadSignature(String.valueOf('S'));
        attribute.setWriteSignature(String.valueOf('S'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        attribute = new AttributeTypeDescription("tagName", (TypeRef)TypeFactory.getString());
        attribute.setReadSignature(String.valueOf('T'));
        attribute.setWriteSignature(String.valueOf('T'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        attribute = new AttributeTypeDescription("namespace", (TypeRef)TypeFactory.getString(), 32780L);
        attribute.setReadSignature(String.valueOf('B'));
        attribute.setWriteSignature(String.valueOf('B'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        attribute = new AttributeTypeDescription("isNil", (TypeRef)TypeFactory.getBool(), 32780L);
        attribute.setReadSignature(String.valueOf('U'));
        attribute.setWriteSignature(String.valueOf('U'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        attribute = new AttributeTypeDescription("elementNamespace", (TypeRef)TypeFactory.getString(), 33587212L);
        attribute.setReadSignature(String.valueOf('B'));
        attribute.setWriteSignature(String.valueOf('B'));
        attribute.setModifiers(0x2000000L);
        objType.addMember((MethodTypeDescription)attribute);
        MethodTypeDescription method = new MethodTypeDescription("generateXmlFor");
        method.setSignature(String.valueOf('G'));
        method.setResultType((TypeRef)TypeFactory.getString());
        method.setModifiers(0x2000000L);
        objType.addMember(method);
        method = new MethodTypeDescription("loadFromUrl");
        method.setSignature(String.valueOf("LU"));
        method.addArgument(new Argument("url", (TypeRef)TypeFactory.getString(), 1L));
        method.setModifiers(0x2000000L);
        method.setModifiers(32768L);
        objType.addMember(method);
        method = new MethodTypeDescription("load");
        method.setSignature(String.valueOf("LX"));
        method.addArgument(new Argument(XML_TEXT, (TypeRef)TypeFactory.getString(), 1L));
        method.setModifiers(0x2000000L);
        method.setModifiers(32768L);
        objType.addMember(method);
        MethodTypeDescription store = new MethodTypeDescription("store");
        store.setSignature(String.valueOf("SS"));
        store.setModifiers(0x2000000L);
        store.addArgument(new Argument("targetFile", (TypeRef)TypeFactory.getString(), 1L));
        MethodTypeDescription storeEnc = new MethodTypeDescription("store");
        storeEnc.setSignature(String.valueOf("SE"));
        storeEnc.addArgument(new Argument("targetFile", (TypeRef)TypeFactory.getString(), 1L));
        storeEnc.addArgument(new Argument("encoding", (TypeRef)TypeFactory.getString(), 1L));
        storeEnc.setModifiers(0x2000000L);
        store = MethodTypeDescription.appendMethod((MethodTypeDescription)store, (MethodTypeDescription)storeEnc);
        objType.addMember(store);
        MethodTypeDescription validate = new MethodTypeDescription("validate");
        validate.setSignature(String.valueOf("V"));
        validate.setModifiers(0x2000000L);
        objType.addMember(validate);
        MethodTypeDescription getValue = new MethodTypeDescription("value");
        getValue.addArgument(new Argument("kind", (TypeRef)TypeFactory.getInt(), 1L));
        getValue.setResultType((TypeRef)TypeFactory.getRootObject());
        getValue.setModifiers(0x2002000L);
        getValue.setSignature(String.valueOf("E"));
        objType.addMember(getValue);
    }

    static {
        XmlTypeHelper.loadXmlObject(XMLOBJECT_NAME, "", false, false);
    }
}

