/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.utils;

import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class HumanTaskHelper {
    private HumanTaskHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription createInvokeXsltMethod(@NotNull TypeDescription humanTask) {
        if (humanTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/utils/HumanTaskHelper.createInvokeXsltMethod must not be null");
        }
        if (!ComponentType.HUMAN_TASK.getText().equals(humanTask.getComponentType())) {
            throw new IllegalArgumentException("Invalid HumanTask type");
        }
        ObjectTypeDescription humanTaskOtd = humanTask.asObject();
        MethodTypeDescription result = new MethodTypeDescription("invokeXslt");
        VFile workFlowFile = (VFile)humanTaskOtd.getTransientProperty("Workflowtask.file");
        XmlTypeDescription argType = XmlTypeDescription.createForExternalXml((String)"task", (String)"http://xmlns.oracle.com/bpel/workflow/task", (String)workFlowFile.getCanonicalPath(), (XmlElementType)XmlElementType.ELEMENT);
        VFile[] files = new VFile[]{workFlowFile};
        argType.setTransientProperty("files", (Object)files);
        argType.setCatalog(humanTask.getCatalog());
        Argument argument = new Argument("task", (TypeRef)argType, 1L);
        result.addArgument(argument);
        MethodTypeDescription methodTypeDescription = result;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/utils/HumanTaskHelper.createInvokeXsltMethod must not return null");
        }
        return methodTypeDescription;
    }
}

