/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.parser;

import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.type.parser.BpmoProperty;
import org.jetbrains.annotations.NotNull;

public class BpmoProperties
extends WsdlElement {
    public BpmoProperties() {
        this.setTagName("properties");
        this.setNamespace("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    public Map<String, String> getProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (BpmoProperty property = (BpmoProperty)this.getFirstElement(); property != null; property = (BpmoProperty)property.getNextElement()) {
            String key = property.getKey();
            if (key.equals("attributes.schema.id")) continue;
            result.put(key, property.getValue());
        }
        return result;
    }

    public void putAll(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoProperties.putAll must not be null");
        }
        for (String key : properties.keySet()) {
            if (key.equals("attributes.schema.id")) continue;
            this.put(key, properties.get(key));
        }
    }

    public void put(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoProperties.put must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoProperties.put must not be null");
        }
        BpmoProperty property = new BpmoProperty();
        property.setKey(key);
        property.setValue(value);
        this.addChild(property);
    }
}

