/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.MissingScriptBuildException;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.type.parser.BpmoScript;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmoOperation
extends WsdlElement {
    public BpmoOperation() {
        this.setTagName("operation");
        this.setNamespace("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    public boolean isVirtual() {
        String s = this.getAttribute("virtual");
        return s != null && Boolean.parseBoolean(s);
    }

    @Nullable
    public String getAttributeName() {
        return this.getAttribute("attribute");
    }

    public void setVirtual(boolean virtual) {
        if (virtual) {
            this.setAttribute("virtual", virtual);
        }
    }

    public void setAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.setAttributeName must not be null");
        }
        if (!Str.isEmpty(attributeName)) {
            this.setAttribute("attribute", attributeName);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MethodTypeDescription buildMethodTypeDescription(@NotNull Operation operation, @NotNull XObjectTypeDescription xotd, @NotNull XmlTypeDescription xmlOtd) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.buildMethodTypeDescription must not be null");
        }
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.buildMethodTypeDescription must not be null");
        }
        if (xmlOtd == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.buildMethodTypeDescription must not be null");
        }
        DefaultElement firstElement = this.getFirstElement();
        if (firstElement == null || !(firstElement instanceof BpmoScript)) {
            throw new MissingScriptBuildException(xotd.getName(), operation.getName());
        }
        BpmoScript bpmoScript = (BpmoScript)firstElement;
        SourceCode sourceCode = bpmoScript.getSourceCode();
        String attributeName = this.getAttributeName();
        MethodTypeDescription result = attributeName != null ? this.createOverridenAttribute(operation, sourceCode, attributeName, xmlOtd) : this.createMethod(operation, xotd, sourceCode);
        MethodTypeDescription methodTypeDescription = result;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/parser/BpmoOperation.buildMethodTypeDescription must not return null");
        }
        return methodTypeDescription;
    }

    private MethodTypeDescription createMethod(@NotNull Operation operation, @NotNull XObjectTypeDescription xotd, @Nullable SourceCode sourceCode) throws TypeBuildException {
        Output output;
        Input input;
        MethodTypeDescription result;
        boolean isConstructor;
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.createMethod must not be null");
        }
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.createMethod must not be null");
        }
        String operationName = operation.getName();
        int i = operationName.lastIndexOf("-");
        if (i != -1) {
            operationName = operationName.substring(0, i);
        }
        if (isConstructor = operationName.equals(xotd.getName())) {
            result = xotd.createConstructor();
        } else {
            result = new MethodTypeDescription(operationName);
            result.setSignature(result.getName());
        }
        List<Argument> inArgs = this.getInputArguments(operation);
        for (Argument arg : inArgs) {
            result.addArgument(arg);
        }
        if (!isConstructor) {
            List<Argument> outArgs = this.getOutputArguments(operation);
            for (Argument arg : outArgs) {
                if (arg.getName().equals("return")) {
                    result.setResultType(arg.getTypeRef());
                    continue;
                }
                result.addArgument(arg);
            }
        }
        if ((input = operation.getInput()) != null) {
            result.setProperty("inputMessage", this.localname(input.getMessage()));
        }
        if ((output = operation.getOutput()) != null) {
            result.setProperty("outputMessage", this.localname(output.getMessage()));
        }
        result.setProperty("nativeName", operationName);
        result.setCode(sourceCode);
        if (!isConstructor) {
            result.setStatic(this.isStaticMethod(operation));
        }
        result.setProperty("mep", operation.getType().toString());
        return result;
    }

    private boolean isStaticMethod(@NotNull Operation operation) throws TypeBuildException {
        Output output;
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.isStaticMethod must not be null");
        }
        boolean result = true;
        Input input = operation.getInput();
        if (input != null) {
            List<Argument> args = input.buildBpmObjectArguments();
            for (Argument arg : args) {
                if (!"this".equals(arg.getName())) continue;
                return false;
            }
        }
        if ((output = operation.getOutput()) != null) {
            List<Argument> args = output.buildBpmObjectArguments();
            for (Argument arg : args) {
                if (!"this".equals(arg.getName())) continue;
                return false;
            }
        }
        return result;
    }

    private MethodTypeDescription createOverridenAttribute(@NotNull Operation operation, @Nullable SourceCode sourceCode, @NotNull String attributeName, XmlTypeDescription xmlOtd) throws TypeBuildException {
        boolean writeAccess;
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.createOverridenAttribute must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.createOverridenAttribute must not be null");
        }
        AttributeTypeDescription result = xmlOtd.findAttribute(attributeName);
        TypeRef typeRef = null;
        List<Argument> inArgs = this.getInputArguments(operation);
        List<Argument> outArgs = this.getOutputArguments(operation);
        if (!inArgs.isEmpty()) {
            typeRef = inArgs.get(0).getTypeRef();
        } else if (!outArgs.isEmpty()) {
            typeRef = outArgs.get(0).getTypeRef();
        }
        if (typeRef == null) {
            // empty if block
        }
        if (result == null) {
            assert (this.isVirtual()) : "If the attribute was not created previously, it must be a virtual attribute";
            result = new AttributeTypeDescription(attributeName, typeRef);
            result.setVirtual(this.isVirtual());
        }
        boolean bl = writeAccess = !inArgs.isEmpty();
        if (writeAccess) {
            result.setWriteCode(sourceCode);
        } else {
            result.setCode(sourceCode);
        }
        return result;
    }

    private List<Argument> getOutputArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.getOutputArguments must not be null");
        }
        Output output = operation.getOutput();
        ArrayList<Argument> outArgs = new ArrayList<Argument>();
        if (output != null) {
            List<Argument> args = output.buildBpmObjectArguments();
            for (Argument arg : args) {
                if ("this".equals(arg.getName())) continue;
                outArgs.add(arg);
            }
        }
        return outArgs;
    }

    private List<Argument> getInputArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoOperation.getInputArguments must not be null");
        }
        Input input = operation.getInput();
        ArrayList<Argument> inArgs = new ArrayList<Argument>();
        if (input != null) {
            List<Argument> args = input.buildBpmObjectArguments();
            for (Argument arg : args) {
                if ("this".equals(arg.getName())) continue;
                inArgs.add(arg);
            }
        }
        return inArgs;
    }
}

