/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.Operation;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.type.Argument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmoDelegate
extends WsdlElement {
    public BpmoDelegate() {
        this.setTagName("delegate");
        this.setNamespace("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    @Nullable
    public String getDelegatedNamespace() {
        return this.getAttribute("delegatedNamespace");
    }

    @Nullable
    public String getDelegatedPortType() {
        return this.getAttribute("delegatedPortType");
    }

    public void setMethodSignature(@NotNull String signature) {
        if (signature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.setMethodSignature must not be null");
        }
        if (!Str.isEmpty(signature)) {
            this.setAttribute("methodSignature", signature);
        }
    }

    public void setDelegatedWsdl(@NotNull String namespace, @NotNull String portType) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.setDelegatedWsdl must not be null");
        }
        if (portType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.setDelegatedWsdl must not be null");
        }
        if (!Str.isEmpty(namespace) && !Str.isEmpty(portType)) {
            this.setAttribute("delegatedNamespace", namespace);
            this.setAttribute("delegatedPortType", portType);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getMethodSignature() {
        String string = this.getAttribute("methodSignature");
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/parser/BpmoDelegate.getMethodSignature must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<Argument> buildArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildArguments must not be null");
        }
        List<Argument> result = this.buildInputArguments(operation);
        result.addAll(this.buildOutputArguments(operation));
        List<Argument> list = result;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildArguments must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<Argument> buildInputArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildInputArguments must not be null");
        }
        Input input = operation.getInput();
        List<Argument> result = input != null ? input.buildBpmObjectArguments() : new ArrayList<Argument>();
        List<Argument> list = result;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildInputArguments must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<Argument> buildOutputArguments(@NotNull Operation operation) throws TypeBuildException {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildOutputArguments must not be null");
        }
        Output output = operation.getOutput();
        List<Argument> result = output != null ? output.buildBpmObjectArguments() : new ArrayList<Argument>();
        List<Argument> list = result;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/parser/BpmoDelegate.buildOutputArguments must not return null");
        }
        return list;
    }
}

