/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.Import;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaElementFactory;
import oracle.bpm.project.catalog.parser.xsd.Sequence;
import oracle.bpm.project.catalog.type.AbstractBpmoTypeWriter;
import oracle.bpm.project.catalog.type.BpmObjectSchemaHelper;
import oracle.bpm.project.catalog.type.BpmoWriterContext;
import oracle.bpm.project.catalog.type.ElementBuilder;
import oracle.bpm.type.TypeCatalogException;
import org.jetbrains.annotations.NotNull;

public class XsdTypeWriter
extends AbstractBpmoTypeWriter {
    static final String DEFAULT_SCHEMA_PREFIX = "xs";

    public XsdTypeWriter(@NotNull XObjectTypeDescription xotd, @NotNull VFile outputFile, @NotNull BpmoWriterContext context) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/XsdTypeWriter.<init> must not be null");
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/XsdTypeWriter.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/XsdTypeWriter.<init> must not be null");
        }
        super(xotd, outputFile, context);
        this.rootContext.addNamespace(DEFAULT_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        this.targetNamespace = xotd.asSchemaObject().getNamespace();
        this.rootContext.addNamespace("", this.targetNamespace);
        this.elementBuilder = new ElementBuilder(this.getXmlSchemaPrefix(), context);
    }

    @Override
    Schema build() throws TypeCatalogException {
        ComplexType complexType = this.buildComplexType(this.xotd);
        ComplexType callbackComplexType = null;
        XObjectTypeDescription callbackotd = null;
        if (this.xotd.hasInnerTypes()) {
            callbackotd = (XObjectTypeDescription)this.xotd.getInnerType(0);
            callbackComplexType = this.buildComplexType(callbackotd);
        }
        Schema schema = this.buildSchema();
        for (Import anImport : this.elementBuilder.getSchemaImports()) {
            anImport.setNSContext(new NamespaceContext(schema.getNSContext()));
            schema.addChild(anImport);
        }
        schema.addChild(complexType);
        String elementName = this.buildElementName(this.xotd, complexType.getName());
        ElementDef elementDef = SchemaElementFactory.createElementWithType(elementName, complexType.getName(), this.rootContext);
        schema.addChild(elementDef);
        if (callbackComplexType != null) {
            schema.addChild(callbackComplexType);
            String callbackCTName = callbackComplexType.getName();
            String callbackElementName = this.buildElementName(callbackotd, callbackCTName);
            ElementDef callBackElementDef = SchemaElementFactory.createElementWithType(callbackElementName, callbackCTName, this.rootContext);
            schema.addChild(callBackElementDef);
        }
        return schema;
    }

    @Override
    String getXmlSchemaPrefix() {
        return DEFAULT_SCHEMA_PREFIX;
    }

    private String buildElementName(@NotNull XObjectTypeDescription xotd, String complexTypeName) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/XsdTypeWriter.buildElementName must not be null");
        }
        String result = xotd.getName();
        if (result.equals(complexTypeName)) {
            result = result + "Element";
        }
        return result;
    }

    private ComplexType buildComplexType(@NotNull XObjectTypeDescription xotd) throws TypeCatalogException {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/XsdTypeWriter.buildComplexType must not be null");
        }
        XmlTypeDescription xmlotd = BpmObjectSchemaHelper.findSchemaForBpmObject(xotd);
        ComplexType complexType = SchemaElementFactory.createComplexType(this.buildComplexTypeNameForBpmObject(xmlotd), this.rootContext);
        Sequence sequence = SchemaElementFactory.createSequence(complexType.getNSContext());
        for (AttributeTypeDescription mtd : BpmObjectTypeDescriptionHelper.getAttributesByPosition((XObjectTypeDescription)xotd)) {
            AttributeTypeDescription atd = mtd;
            if (atd.isVirtual() || atd.isHidden()) continue;
            ElementDef element = this.elementBuilder.buildElementForAttribute(atd, sequence.getNSContext(), this.rootContext);
            if (element != null) {
                DefaultElement doc = XsdTypeWriter.buildDocumentation((TypeDescription)atd, element.getNSContext());
                if (doc.hasChilds()) {
                    element.insertFirstChild(doc);
                }
                sequence.addChild(element);
                continue;
            }
            throw new TypeCatalogException(xotd.getCatalog(), ProjectCatalogMsg.UNSUPPORTED_TYPE(atd.getType()));
        }
        if (sequence.hasChilds()) {
            complexType.addChild(sequence);
        }
        return complexType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String buildComplexTypeNameForBpmObject(XmlTypeDescription xmltd) {
        String string;
        SchemaObject so = xmltd.asSchemaObject();
        if (xmltd.getXmlElementType() == XmlElementType.ELEMENT) {
            QName qName = so.getElementTypeQName();
            assert (qName != null);
            string = qName.getLocalPart();
            if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/XsdTypeWriter.buildComplexTypeNameForBpmObject must not return null");
            return string;
        }
        assert (xmltd.getXmlElementType() == XmlElementType.TYPE);
        string = so.getName();
        if (string != null) return string;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/XsdTypeWriter.buildComplexTypeNameForBpmObject must not return null");
    }

    private Schema buildSchema() {
        Schema schema = SchemaElementFactory.createSchema(this.targetNamespace);
        schema.setNSContext(this.rootContext);
        return schema;
    }
}

