/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import oracle.bpm.bpmobject.BpmObjectFactory;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.TypeErrorExceptionInterface;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.impl.TypeErrorImpl;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorTypeFactory {
    private static final String INVALID_RESOURCE = "InvalidResource";

    private ErrorTypeFactory() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectTypeDescription createObjectErrorType(@NotNull String typeName, @NotNull ErrorMsg msg) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createObjectErrorType must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createObjectErrorType must not be null");
        }
        TypeErrorImpl typeError = TypeErrorImpl.create((ErrorMsg)msg, (Exception)null);
        ObjectTypeDescription objectTypeDescription = ErrorTypeFactory.createError(typeName, (TypeError)typeError, null, null);
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createObjectErrorType must not return null");
        }
        return objectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectTypeDescription createErrorResourceType(@NotNull URI uri, @Nullable URI dependant, @NotNull TypeErrorExceptionInterface error) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        if (error == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        TypeError typeError = error.getTypeError();
        String typeName = ErrorTypeFactory.getObjectNameFromUri(uri);
        ObjectTypeDescription objectTypeDescription = ErrorTypeFactory.createError(typeName, typeError, uri, dependant);
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not return null");
        }
        return objectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectTypeDescription createErrorResourceType(@NotNull URI uri, @NotNull ErrorMsg msg) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        ObjectTypeDescription objectTypeDescription = ErrorTypeFactory.createErrorResourceType(uri, msg, null);
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not return null");
        }
        return objectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ObjectTypeDescription createErrorResourceType(@NotNull URI uri, @NotNull ErrorMsg msg, @Nullable Exception exception) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        if (msg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not be null");
        }
        TypeErrorImpl typeError = TypeErrorImpl.create((Msg)msg, (ErrorMsg)msg, (Exception)exception);
        String typeName = ErrorTypeFactory.getObjectNameFromUri(uri);
        ObjectTypeDescription objectTypeDescription = ErrorTypeFactory.createError(typeName, (TypeError)typeError, uri, null);
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorResourceType must not return null");
        }
        return objectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XObjectTypeDescription createErrorBO(@NotNull String typeName, @NotNull ErrorMsg errorMsg, @NotNull ComponentCatalog catalog, @Nullable Exception rootCause) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        XObjectTypeDescription result = BpmObjectFactory.createXObjectTypeDescription((String)typeName, (String)catalog.getRoot().getText(), (ComponentCatalog)catalog);
        TypeErrorImpl typeError = TypeErrorImpl.create((ErrorMsg)errorMsg, (Exception)rootCause);
        result.addError((TypeError)typeError);
        XObjectTypeDescription xObjectTypeDescription = result;
        if (xObjectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not return null");
        }
        return xObjectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static XObjectTypeDescription createErrorBO(@NotNull String typeName, @NotNull String module, @NotNull ComponentCatalog catalog, @NotNull TypeBuildException rootCause) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        if (rootCause == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not be null");
        }
        XObjectTypeDescription result = BpmObjectFactory.createXObjectTypeDescription((String)typeName, (String)module, (ComponentCatalog)catalog);
        result.addError(rootCause.getTypeError());
        XObjectTypeDescription xObjectTypeDescription = result;
        if (xObjectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createErrorBO must not return null");
        }
        return xObjectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getObjectNameFromUri(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.getObjectNameFromUri must not be null");
        }
        String path = uri.getPath();
        String result = path != null ? path : uri.toString();
        String string = Identifier.classname(result);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.getObjectNameFromUri must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ObjectTypeDescription createError(@NotNull String typeName, @NotNull TypeError typeError, @Nullable URI uri, @Nullable URI dependant) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createError must not be null");
        }
        if (typeError == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.createError must not be null");
        }
        if (Str.isEmpty(typeName)) {
            typeName = INVALID_RESOURCE;
        }
        ObjectTypeDescription result = (ObjectTypeDescription)ErrorTypeFactory.buildErrorTypeDesc(typeName, typeError);
        URI failedResource = uri;
        if (typeError.getCause() instanceof FileNotFoundException) {
            failedResource = dependant;
        }
        if (failedResource != null) {
            try {
                VFile vfile = URLHelper.getFromURI((URI)failedResource);
                if (vfile != null) {
                    result.setTransientProperty("resource_error", (Object)vfile);
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (uri != null) {
            String relativeUrl;
            try {
                relativeUrl = URLHelper.getResourceLocation((URI)uri);
            }
            catch (IOException e) {
                relativeUrl = uri.toString();
            }
            result.setTransientProperty("resource_location", (Object)relativeUrl);
            try {
                VFile vfile = URLHelper.getFromURI((URI)uri);
                if (vfile != null) {
                    result.setTransientProperty("files", (Object)new VFile[]{vfile});
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        ObjectTypeDescription objectTypeDescription = result;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.createError must not return null");
        }
        return objectTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TypeDescription buildErrorTypeDesc(@NotNull String typeName, @NotNull TypeError typeError) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.buildErrorTypeDesc must not be null");
        }
        if (typeError == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/ErrorTypeFactory.buildErrorTypeDesc must not be null");
        }
        ObjectTypeDescription result = new ObjectTypeDescription(typeName);
        result.setComponentType(ComponentType.CORRUPTED_RESOURCE.getText());
        result.addModifier(0x100000000L);
        result.addError(typeError);
        ObjectTypeDescription objectTypeDescription = result;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/type/ErrorTypeFactory.buildErrorTypeDesc must not return null");
        }
        return objectTypeDescription;
    }
}

