/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.type.BpmObjectSchemaHelper;
import oracle.bpm.project.catalog.type.BpmoWriterContext;
import oracle.bpm.project.catalog.type.WsdlTypeWriter;
import oracle.bpm.project.catalog.type.XsdTypeWriter;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class BpmObjectWriter {
    public static final String BMPO_PROCESS_INSTRUCTION = "bpmo";
    public static final String BMPO_PROCESSING_INSTRUCTION_LINE = "<?bpmo version=\"%s\" build=\"%s\" fullName=\"%s\" modifiers=\"%s\"?>\n";

    public static Map<VFile, ResourceType> write(@NotNull ObjectTypeDescription objectType, @NotNull VFile baseDir) throws TypeCatalogException {
        if (objectType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.write must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.write must not be null");
        }
        if (objectType.isSynthesized() || Boolean.parseBoolean(objectType.getProperty("is.callback")) || !objectType.isModule() && !objectType.isBpmObject()) {
            return Collections.emptyMap();
        }
        String fname = objectType.getText().replace('.', '/');
        VFile xsdFile = BpmObjectWriter.getXsdFile(fname, baseDir);
        VFile wsdlFile = BpmObjectWriter.getWsdlFile(fname, baseDir);
        VFile parentFile = xsdFile.getParentFile();
        LinkedHashMap<VFile, ResourceType> files = new LinkedHashMap<VFile, ResourceType>();
        try {
            parentFile.mkdirs();
            if (objectType.isBpmObject()) {
                XObjectTypeDescription xotd = (XObjectTypeDescription)objectType;
                String baseLocation = BpmObjectWriter.buildBaseLocation(xotd);
                BpmoWriterContext context = new BpmoWriterContext(baseLocation + xsdFile.getName(), baseLocation + wsdlFile.getName());
                XmlUUID xmlUUID = UUIDFactory.parseXmlId((String)TypeUtils.getAttributesObjectId((ObjectTypeDescription)xotd));
                if (Utils.isBpmObjectNamespace(xmlUUID.getNamespace())) {
                    XsdTypeWriter xsdTypeWriter = new XsdTypeWriter(xotd, xsdFile, context);
                    xsdTypeWriter.write();
                    XmlTypeDescription xmlotd = BpmObjectSchemaHelper.findSchemaForBpmObject(xotd);
                    xmlotd.setTransientProperty("files", (Object)new VFile[]{xsdFile});
                    files.put(xsdFile, ResourceType.XML_SCHEMA);
                }
                WsdlTypeWriter wsdlTypeWriter = new WsdlTypeWriter(xotd, wsdlFile, context);
                wsdlTypeWriter.write();
                xotd.setTransientProperty("files", (Object)new VFile[]{wsdlFile});
                files.put(wsdlFile, ResourceType.BPM_OBJECT);
            } else if (objectType.isModule()) {
                VFile module = parentFile.getFileSystem().createFile(parentFile, objectType.getName());
                files.put(module, ResourceType.MUTABLE_MODULE);
                module.mkdirs();
            }
        }
        catch (IOException e) {
            throw new TypeCatalogException((Exception)e);
        }
        return files;
    }

    public static VFile getWsdlFile(@NotNull String typeName, @NotNull VFile baseDir) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getWsdlFile must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getWsdlFile must not be null");
        }
        String fname = typeName.replace('.', '/');
        return baseDir.getFileSystem().createFile(baseDir, fname + ".wsdl");
    }

    public static List<VFile> deleteBpmObject(@NotNull String typeName, @NotNull VFile baseDir) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.deleteBpmObject must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.deleteBpmObject must not be null");
        }
        ArrayList<VFile> files = new ArrayList<VFile>();
        VFile xsdFile = BpmObjectWriter.getXsdFile(typeName, baseDir);
        VFile wsdlFile = BpmObjectWriter.getWsdlFile(typeName, baseDir);
        if (BpmObjectWriter.deleteFile(wsdlFile)) {
            files.add(wsdlFile);
        }
        if (BpmObjectWriter.deleteFile(xsdFile)) {
            files.add(xsdFile);
        }
        return files;
    }

    public static List<VFile> deleteModule(@NotNull String typeName, @NotNull VFile baseDir) throws TypeCatalogException {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.deleteModule must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.deleteModule must not be null");
        }
        ArrayList<VFile> files = new ArrayList<VFile>();
        VFile folder = BpmObjectWriter.getFolderFromModule(typeName, baseDir);
        try {
            BpmObjectWriter.addFilesFromFolder(folder, files);
            boolean wasRemoved = VFileUtils.deleteDirectory((VFile)folder);
            if (!wasRemoved) {
                throw new TypeCatalogException(null, CoreMsg.COULDNOTDELETEFILE(folder.getCanonicalPath(), "unknown"));
            }
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, CoreMsg.COULDNOTDELETEFILE(folder.getCanonicalPath(), "unknown").toString(), (Exception)e);
        }
        return files;
    }

    private static VFile getXsdFile(@NotNull String typeName, @NotNull VFile baseDir) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getXsdFile must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getXsdFile must not be null");
        }
        String fname = typeName.replace('.', '/');
        return baseDir.getFileSystem().createFile(baseDir, fname + ".xsd");
    }

    private static void addFilesFromFolder(VFile folder, List<VFile> files) throws IOException {
        for (VFile vFile : folder.listFiles(null)) {
            if (!vFile.isDirectory()) {
                files.add(vFile);
                continue;
            }
            BpmObjectWriter.addFilesFromFolder(vFile, files);
        }
    }

    private static boolean deleteFile(@NotNull VFile file) throws TypeCatalogException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.deleteFile must not be null");
        }
        try {
            boolean deleted = false;
            if (file.exists()) {
                boolean bl = deleted = file.isDirectory() ? VFileUtils.deleteDirectory((VFile)file) : file.delete();
                if (!deleted && file.exists()) {
                    String reason = "unknown";
                    VFile dir = file.getParentFile();
                    if (dir != null && dir.exists() && !dir.canWrite()) {
                        reason = "Permission denied to modify files in directory: '" + dir.getCanonicalPath() + '\'';
                    } else {
                        String os = System.getProperty("os.name");
                        if (os != null && os.contains("Windows")) {
                            reason = "Maybe it is being used by another person or program. Close any programs that might be using the file and try again";
                        }
                    }
                    throw new TypeCatalogException(null, CoreMsg.COULDNOTDELETEFILE(file.getCanonicalPath(), reason));
                }
            }
            return deleted;
        }
        catch (IOException e) {
            throw new TypeCatalogException(null, CoreMsg.COULDNOTDELETEFILE(file.getCanonicalPath(), e.getMessage()).toString(), (Exception)e);
        }
    }

    private static VFile getFolderFromModule(@NotNull String typeName, @NotNull VFile baseDir) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getFolderFromModule must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.getFolderFromModule must not be null");
        }
        String fname = typeName.replace('.', '/');
        return baseDir.getFileSystem().createFile(baseDir, fname);
    }

    private static String buildBaseLocation(@NotNull XObjectTypeDescription xotd) {
        if (xotd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/type/BpmObjectWriter.buildBaseLocation must not be null");
        }
        char sep = '/';
        StringBuilder builder = new StringBuilder();
        builder.append(sep);
        builder.append("businessCatalog");
        builder.append(sep);
        TypeDescription parent = xotd.getParent();
        if (parent != null) {
            builder.append(parent.getText().replace('.', sep));
            builder.append(sep);
        }
        return builder.toString();
    }
}

