/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.recognizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.recognizer.BPMObjectResourceRecognizer;
import oracle.bpm.project.catalog.recognizer.BusinessRuleSchemaResourceRecognizer;
import oracle.bpm.project.catalog.recognizer.CompositeResourceRecognizer;
import oracle.bpm.project.catalog.recognizer.EventResourceRecognizer;
import oracle.bpm.project.catalog.recognizer.FileHeader;
import oracle.bpm.project.catalog.recognizer.HumanTaskSchemaResourceRecognizer;
import oracle.bpm.project.catalog.recognizer.MutableModuleRecognizer;
import oracle.bpm.project.catalog.recognizer.ResourceListener;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.recognizer.ResourceTypeRecognizer;
import oracle.bpm.project.catalog.recognizer.XmlSchemaResourceRecognizer;
import oracle.bpm.project.catalog.type.ResourceListenerException;
import oracle.bpm.project.catalog.type.TypeLoadRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFileSystemBundleContext {
    boolean resourcesLoaded;
    private VFile businessCatalogFolder;
    private VFileSystem fileSystem;
    private final Queue<ResourceListener> listeners;
    private final List<ResourceTypeRecognizer> recognizers;
    private final Map<ResourceType, Set<VFile>> resourcesByType;
    private static String[] SKIP_DIRECTORIES_ARRAY = new String[]{"lib", "system", "config", ".svn", "SCA-INF", "classes"};
    private static Set<String> SKIP_DIRECTORIES = new HashSet<String>(Arrays.asList(SKIP_DIRECTORIES_ARRAY));

    public VFileSystemBundleContext(@NotNull VFileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.<init> must not be null");
        }
        this.recognizers = new ArrayList<ResourceTypeRecognizer>();
        this.resourcesByType = new HashMap<ResourceType, Set<VFile>>();
        this.fileSystem = fileSystem;
        this.listeners = new ConcurrentLinkedQueue<ResourceListener>();
        this.initRecognizer();
        this.initVFilesystemListener();
    }

    public VFileSystem getFileSystem() {
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Iterable<VFile> getResourcesByType(@NotNull ResourceType resourceType) throws IOException {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.getResourcesByType must not be null");
        }
        Map<ResourceType, Set<VFile>> map = this.resourcesByType;
        synchronized (map) {
            this.ensureResourcesLoaded();
            Set<VFile> resources = this.resourcesByType.get((Object)resourceType);
            return resources != null ? new HashSet<VFile>(resources) : null;
        }
    }

    public void addListener(@NotNull ResourceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.addListener must not be null");
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        Map<ResourceType, Set<VFile>> map = this.resourcesByType;
        synchronized (map) {
            this.resourcesByType.clear();
            this.resourcesLoaded = false;
            this.ensureResourcesLoaded();
        }
    }

    @Nullable
    public ResourceType processResourceType(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.processResourceType must not be null");
        }
        FileHeader fileHeader = FileHeader.createFileHeader(vFile);
        return this.processResourceType(fileHeader);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFile getBusinessCatalogFolder() {
        if (this.businessCatalogFolder == null) {
            VFile rootFolder = this.fileSystem.getRoot();
            this.businessCatalogFolder = this.fileSystem.createFile(rootFolder, "businessCatalog");
        }
        VFile vFile = this.businessCatalogFolder;
        if (vFile == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.getBusinessCatalogFolder must not return null");
        }
        return vFile;
    }

    private void addResourceRecognizer(@NotNull ResourceTypeRecognizer recognizer) {
        if (recognizer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.addResourceRecognizer must not be null");
        }
        this.recognizers.add(recognizer);
    }

    private void initVFilesystemListener() {
        this.fileSystem.addListener(new VFileEventListener(){

            public void onFileEvent(@NotNull VFileEvent event) {
                ResourceType newResourceType = null;
                VFile vFile = event.getSource();
                VEventType eventType = event.getType();
                try {
                    if (eventType == VEventType.ADD && !vFile.isDirectory()) {
                        newResourceType = VFileSystemBundleContext.this.processResourceType(vFile);
                    }
                }
                catch (IOException e) {
                    throw new TypeLoadRuntimeException(ProjectCatalogMsg.UNEXPECTED_IO_ERROR(vFile.toString()), (Throwable)e);
                }
                if (eventType != null) {
                    try {
                        for (ResourceListener listener : VFileSystemBundleContext.this.listeners) {
                            switch (eventType) {
                                case ADD: {
                                    if (newResourceType == null) break;
                                    listener.resourceAdded(newResourceType, vFile);
                                    break;
                                }
                                case CHANGE: {
                                    listener.resourceUpdated(vFile);
                                    break;
                                }
                                case REMOVE: {
                                    listener.resourceDeleted(vFile);
                                }
                            }
                        }
                    }
                    catch (ResourceListenerException e) {
                        throw new TypeLoadRuntimeException(e);
                    }
                }
            }
        });
    }

    private void initRecognizer() {
        this.addResourceRecognizer(new CompositeResourceRecognizer());
        this.addResourceRecognizer(new BPMObjectResourceRecognizer());
        this.addResourceRecognizer(new HumanTaskSchemaResourceRecognizer());
        this.addResourceRecognizer(new BusinessRuleSchemaResourceRecognizer());
        this.addResourceRecognizer(new XmlSchemaResourceRecognizer());
        this.addResourceRecognizer(new MutableModuleRecognizer());
        this.addResourceRecognizer(new EventResourceRecognizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(@NotNull ResourceType resourceType, @NotNull VFile resource) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.addResource must not be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.addResource must not be null");
        }
        Map<ResourceType, Set<VFile>> map = this.resourcesByType;
        synchronized (map) {
            Set<VFile> resourceSet = this.resourcesByType.get((Object)resourceType);
            if (resourceSet == null) {
                resourceSet = new HashSet<VFile>();
                this.resourcesByType.put(resourceType, resourceSet);
            }
            resourceSet.add(resource);
        }
    }

    @Nullable
    private ResourceType processResourceType(@NotNull FileHeader fileHeader) {
        if (fileHeader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.processResourceType must not be null");
        }
        ResourceType result = null;
        for (ResourceTypeRecognizer recognizer : this.recognizers) {
            if (!recognizer.recognizeResource(fileHeader)) continue;
            result = recognizer.getResourceType();
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureResourcesLoaded() throws IOException {
        Map<ResourceType, Set<VFile>> map = this.resourcesByType;
        synchronized (map) {
            if (!this.resourcesLoaded) {
                this.resourcesLoaded = true;
                ArrayList<FileHeader> fileHeaders = new ArrayList<FileHeader>();
                this.ensureResourcesLoadedRecursive(this.fileSystem.getRoot(), fileHeaders);
                FileHeader[] sortedHeaders = fileHeaders.toArray(new FileHeader[fileHeaders.size()]);
                Arrays.sort(sortedHeaders, new Comparator<FileHeader>(){

                    @Override
                    public int compare(FileHeader header1, FileHeader header2) {
                        int result = -1;
                        for (ResourceTypeRecognizer recognizer : VFileSystemBundleContext.this.recognizers) {
                            if (recognizer.recognizeByFileExtension(header1)) {
                                if (!recognizer.recognizeByFileExtension(header2)) break;
                                result = 0;
                                break;
                            }
                            if (!recognizer.recognizeByFileExtension(header2)) continue;
                            result = 1;
                            break;
                        }
                        return result;
                    }
                });
                for (FileHeader header : sortedHeaders) {
                    ResourceType resourceType = this.processResourceType(header);
                    if (resourceType == null) continue;
                    this.addResource(resourceType, header.getFile());
                }
            }
        }
    }

    private void ensureResourcesLoadedRecursive(@NotNull VFile resource, @NotNull Collection<FileHeader> resources) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.ensureResourcesLoadedRecursive must not be null");
        }
        if (resources == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/recognizer/VFileSystemBundleContext.ensureResourcesLoadedRecursive must not be null");
        }
        if (!resource.isHidden() || resource.getName().charAt(0) != '.') {
            if (resource.isDirectory()) {
                if (!SKIP_DIRECTORIES.contains(resource.getName())) {
                    for (VFile vfile : resource.listFiles(null)) {
                        this.ensureResourcesLoadedRecursive(vfile, resources);
                    }
                    resources.add(FileHeader.createFileHeader(resource));
                }
            } else {
                resources.add(FileHeader.createFileHeader(resource));
            }
        }
    }
}

