/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.HashMap;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.parser.xsd.Attribute;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class SOAPNamespace
extends ExtendedNamespace {
    private static final HashMap<String, SOAPNamespace> instances = new HashMap();
    static final long serialVersionUID = -2186638981905566589L;
    static final long serialCheck = 1045482725475285156L;

    private SOAPNamespace(String uri) {
        super(uri);
        this.addType("Array", (TypeDescription)TypeFactory.getArray((TypeRef)TypeFactory.getAny()), null);
        AttributeTypeDescription attrType = new AttributeTypeDescription("arrayType", (TypeRef)TypeFactory.getString());
        this.attributes.put("arrayType", new Attribute(attrType));
        this.addType("string", TypeFactory.getString(), null);
        this.addType("double", TypeFactory.getReal(), "double");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPNamespace get(String uri) {
        HashMap<String, SOAPNamespace> hashMap = instances;
        synchronized (hashMap) {
            SOAPNamespace result = instances.get(uri);
            if (result == null) {
                result = new SOAPNamespace(uri);
                instances.put(uri, result);
            }
            return result;
        }
    }

    static boolean isSOAPSchema(String uri) {
        return "http://schemas.xmlsoap.org/soap/encoding/".equals(uri);
    }

    static boolean isSOAPWsdlSchema(String uri) {
        return "http://schemas.xmlsoap.org/wsdl/".equals(uri);
    }

    @Override
    void declareAnonymous(@NotNull TypeDescription type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareAnonymous must not be null");
        }
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareAttribute(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareAttribute must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareAttribute must not be null");
        }
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareAttributeGroup(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareAttributeGroup must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareAttributeGroup must not be null");
        }
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareElement(@NotNull String name, @NotNull SchemaElement element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareElement must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/SOAPNamespace.declareElement must not be null");
        }
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareGroup(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    @Override
    void declareType(String name, SchemaElement element) {
        throw new UnsupportedOperationException("Attempt to modify SOAP namespace");
    }

    private void addType(String name, TypeDescription type, String javaType) {
        SchemaElement typeHolder = new SchemaElement();
        typeHolder.setTypeDescription(type);
        typeHolder.setJavaType(javaType);
        typeHolder.setNamespace(this.getUri());
        typeHolder.setAttribute("name", name);
        this.types.put(name, typeHolder);
    }
}

