/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.List;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.lang.DelegatedMethodTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlEnumTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xsd.AttrGroupTypeDescription;
import oracle.bpm.project.catalog.parser.xsd.ComplexType;
import oracle.bpm.project.catalog.parser.xsd.ComponentDef;
import oracle.bpm.project.catalog.parser.xsd.ElementDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaElement;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.SimpleType;
import oracle.bpm.project.catalog.parser.xsd.exception.ContextLookupException;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.project.catalog.xmltype.XmlTypeHelper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementRootDef
extends ComponentDef {
    public ElementRootDef(ElementDef element) {
        this.setElementType(11);
        this.setTagName(element.getTagName());
        this.setNamespace(element.getNamespace());
        this.setAttributes(element.getAttributes());
        this.setXMLParser(element.getXMLParser());
        this.setNSContext(element.getContext());
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        boolean hasType;
        if (this.type != null) {
            return this.type;
        }
        String substitution = this.getSubstitutionGroup();
        boolean isSubstitution = substitution != null;
        String ref = this.getRef();
        boolean isRef = ref != null;
        try {
            if (isRef) {
                String prefix = XmlUtils.prefix((String)ref);
                String name = XmlUtils.localname((String)ref);
                ExtendedNamespace extendedNamespace = (ExtendedNamespace)this.getContext().findNamespace(prefix);
                SchemaElement refElement = extendedNamespace.lookupElement(name);
                this.type = refElement.getTypeDescription();
                return this.type;
            }
            if (isSubstitution) {
                String qname = this.getName();
                String prefix = XmlUtils.prefix((String)qname);
                String name = XmlUtils.localname((String)qname);
                ExtendedNamespace extendedNamespace = (ExtendedNamespace)this.getContext().findNamespace(prefix);
                ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
                TypeRef typeRef = this.getContext().lookupElementRef(substitution, catalog);
                this.type = XmlTypeDescription.createPointerToElement((String)name, (String)extendedNamespace.getUri(), (TypeRef)typeRef);
                return this.type;
            }
        }
        catch (ContextLookupException e) {
            throw TypeNotFoundException.wrap(e, (DefaultElement)this);
        }
        TypeDescription object = super.buildType(current);
        SchemaElement first = this.getFirst();
        this.type = object;
        if (first instanceof ComplexType) {
            TypeDescription complexType = first.buildType(object);
            ElementRootDef.addTypeAttributes(object, complexType);
            for (TypeRef typeRef : complexType.asObject().getInnerTypeRefs()) {
                object.asObject().addInnerType(typeRef);
            }
        } else if (first instanceof SimpleType) {
            TypeDescription td = first.buildType(object);
            if (td != null && object != null) {
                if (td.isEnum()) {
                    XmlEnumTypeDescription enumType = (XmlEnumTypeDescription)td;
                    ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
                    String namespace = this.getTarget().getUri();
                    ObjectTypeDescription otd = object.asObject();
                    XmlTypeHelper.addElementTypeInfo(otd, enumType.getNativeName(), namespace, (TypeRef)new DynamicRef((ObjectTypeDescription)enumType, catalog));
                    otd.addInnerType((TypeRef)enumType);
                    enumType.addModifier(0x2000000L);
                    try {
                        this.getTarget().declareAnonymous((TypeDescription)enumType);
                    }
                    catch (InvalidLocalNameException e) {
                        throw TypeNotFoundException.wrap(e, (DefaultElement)this);
                    }
                } else {
                    SchemaObject so = td.asSchemaObject();
                    XmlTypeHelper.addElementTypeInfo(object.asObject(), so.getName(), so.getNamespace(), (TypeRef)td);
                }
            }
        } else {
            AttrGroupTypeDescription attributes;
            if (current != null && current.isAttribute()) {
                current.asAttribute().setType((TypeRef)object);
            }
            if ((attributes = this.buildAttributes(object, true)) != null) {
                if (this.isMixed()) {
                    // empty if block
                }
                attributes.addTo(object.asObject());
            }
        }
        String declaredType = this.getType();
        boolean bl = hasType = declaredType != null;
        if (hasType) {
            try {
                this.setTypeInfo(object.asObject(), declaredType);
            }
            catch (ContextLookupException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
        this.type = object;
        return object;
    }

    @Nullable
    private String getOperationNativeName(@NotNull CatalogMember member) {
        MethodTypeDescription originalMtd;
        DelegatedMethodTypeDescription dmtd;
        TypeDescription service;
        if (member == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ElementRootDef.getOperationNativeName must not be null");
        }
        MethodTypeDescription mtd = member.getMemberType();
        String result = mtd.getNativeName();
        if (mtd.isDelegated() && (service = (dmtd = mtd.asDelegated()).getDelegatedService().get()) != null && !service.isUnknown() && (originalMtd = service.asObject().getMemberBySignature(dmtd.getDelegatedMethodSignature())) != null) {
            result = originalMtd.getNativeName();
        }
        return result;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareElement(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
    }

    @Override
    boolean isAbstract() {
        return Boolean.TRUE.toString().equals(this.getAttribute("abstract"));
    }

    boolean isMixed() {
        return "true".equals(this.getAttribute("mixed"));
    }

    String getRef() {
        return this.getAttribute("ref");
    }

    String getSubstitutionGroup() {
        return this.getAttribute("substitutionGroup");
    }

    String getType() {
        return this.getAttribute("type");
    }

    private static void addTypeAttributes(TypeDescription object, TypeDescription contentType) {
        ObjectTypeDescription otd = object.asObject();
        List attributes = contentType.asObject().getAttributes();
        for (MethodTypeDescription att : attributes) {
            otd.addMember(att.clone());
        }
    }

    private void setTypeInfo(@NotNull ObjectTypeDescription object, @NotNull String declaredType) throws TypeBuildException, ContextLookupException {
        if (object == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ElementRootDef.setTypeInfo must not be null");
        }
        if (declaredType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/xsd/ElementRootDef.setTypeInfo must not be null");
        }
        String prefix = XmlUtils.prefix((String)declaredType);
        ExtendedNamespace extendedNamespace = (ExtendedNamespace)this.getContext().findNamespace(prefix);
        String name = XmlUtils.localname((String)declaredType);
        String namespace = extendedNamespace.getUri();
        ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
        TypeRef ref = this.getContext().lookupTypeDynamicRef(declaredType, catalog);
        XmlTypeHelper.addElementTypeInfo(object, name, namespace, ref);
    }
}

