/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xsd;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.XMLSignatureParser;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xsd.AttributeDef;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.parser.xsd.exception.InvalidLocalNameException;
import oracle.bpm.project.catalog.parser.xsd.exception.NamespaceNotDeclaredException;
import oracle.bpm.project.catalog.parser.xsd.exception.TypeNotFoundException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

public class Attribute
extends AttributeDef {
    public Attribute() {
    }

    public Attribute(AttributeTypeDescription type) {
        this.type = type;
    }

    @Override
    @Nullable
    protected TypeDescription buildType(TypeDescription current) throws TypeBuildException {
        AttributeTypeDescription attr;
        if (this.type != null) {
            return this.type;
        }
        String ref = this.getRef();
        Boolean isQualified = this.getSchema().isAttributeQualified();
        ExtendedNamespace currentNamespace = this.getContext().getTarget();
        String elementNamespace = currentNamespace.getUri();
        if (ref != null) {
            TypeRef attRef;
            ComponentCatalog catalog = ((SchemaParser)this.getXMLParser()).getCatalog();
            try {
                attRef = this.getContext().lookupAttributeRef(ref, catalog);
            }
            catch (NamespaceNotDeclaredException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
            String name = this.localName(ref);
            attr = new AttributeTypeDescription(name, attRef);
            Namespace elemNs = this.getContext().findNamespace(this.prefix(ref));
            if (elementNamespace != null) {
                elementNamespace = elemNs.getUri();
            }
            attr.setReadSignature('A' + name);
            attr.setWriteSignature('A' + name);
            isQualified = true;
        } else {
            String defaultValue;
            String typeSig;
            attr = super.buildType(current).asAttribute();
            if (!(attr.getTypeRef() instanceof DynamicRef)) {
                if (attr.getType().isAny()) {
                    attr.setType((TypeRef)TypeFactory.getString());
                }
                typeSig = Attribute.buildSignature(attr.getType());
            } else {
                typeSig = String.valueOf('X') + attr.getName();
            }
            attr.setReadSignature(attr.getReadSignature() + ";" + typeSig);
            attr.setWriteSignature(attr.getWriteSignature() + ";" + typeSig);
            String fixed = this.getFixed();
            if (fixed != null) {
                attr.setProperty("fixedValue", fixed);
            }
            if ((defaultValue = this.getDefault()) != null) {
                attr.setProperty("defaultValue", defaultValue);
            }
            attr.setProperty("isXsdAttribute", Boolean.TRUE.toString());
            attr.setProperty("nativeName", this.getName());
            this.type = attr;
            String form = this.getForm();
            if (form != null) {
                isQualified = "qualified".equals(form);
                attr.setProperty("isFormQualified", isQualified.toString());
            }
        }
        if (attr != null) {
            attr.setProperty("namespace", elementNamespace);
            if (!isQualified.booleanValue()) {
                elementNamespace = "";
            }
            attr.setProperty("elementNamespace", elementNamespace);
            attr.setProperty("qualified", isQualified.toString());
            String signature = attr.getReadSignature();
            signature = XMLSignatureParser.replaceAttributeElementNamespace((String)signature, (String)elementNamespace);
            attr.setReadSignature(signature);
            attr.setWriteSignature(signature);
        }
        return attr;
    }

    @Override
    protected void declare() throws TypeBuildException {
        String name = this.getName();
        if (name != null) {
            try {
                this.getTarget().declareAttribute(name, this);
            }
            catch (InvalidLocalNameException e) {
                throw TypeNotFoundException.wrap(e, (DefaultElement)this);
            }
        }
    }

    String getArrayType() {
        String nspace = "http://schemas.xmlsoap.org/wsdl/";
        String attrName = "arrayType";
        QName qname = new QName(nspace, attrName);
        String value = this.getAttribute(qname);
        if (value == null) {
            Map<QName, String> attributes = this.getAttributes();
            Set<Map.Entry<QName, String>> entries = attributes.entrySet();
            for (Map.Entry<QName, String> pair : entries) {
                Namespace ns;
                String name = pair.getKey().getLocalPart();
                if (!name.endsWith(":" + attrName) && !name.equals(attrName)) continue;
                int index = name.lastIndexOf(":");
                String prefix = "";
                if (index != -1) {
                    prefix = name.substring(0, index);
                }
                if ((ns = this.getContext().findNamespace(prefix)) == null || !ns.getUri().equals(nspace)) continue;
                value = pair.getValue();
                break;
            }
        }
        return value;
    }

    String getFixed() {
        return this.getAttribute("fixed");
    }

    String getDefault() {
        return this.getAttribute("default");
    }
}

