/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.type.catalog.ComponentBundle;
import org.jetbrains.annotations.NotNull;

public class ParserContext {
    private Set<String> bundles;
    private Map<URI, ServiceDefinition> parsedWsdlFiles;
    private VFileSystem vFileSystem;

    public ParserContext(@NotNull VFileSystem filesystem) {
        if (filesystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/ParserContext.<init> must not be null");
        }
        this.parsedWsdlFiles = new HashMap<URI, ServiceDefinition>();
        this.bundles = new HashSet<String>();
        this.vFileSystem = filesystem;
    }

    public void init(ComponentBundle bundle) {
        String bundleId = bundle.getUniqueId();
        if (this.bundles.contains(bundleId)) {
            this.clean();
        }
        this.bundles.add(bundleId);
    }

    public VFileSystem getVFileSystem() {
        return this.vFileSystem;
    }

    public String resolvePath(@NotNull URL location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/ParserContext.resolvePath must not be null");
        }
        String relativePath = this.vFileSystem != null && "vfile".equals(location.getProtocol()) ? this.vFileSystem.createFile(location.getPath()).getCanonicalPath() : location.toString();
        return relativePath;
    }

    public ServiceDefinition getServiceDefinition(URI uri) {
        uri = uri.normalize();
        return this.parsedWsdlFiles.get(uri);
    }

    public void addParsedWsdlFile(URI uri, ServiceDefinition serviceDefinition) {
        uri = uri.normalize();
        this.parsedWsdlFiles.put(uri, serviceDefinition);
    }

    public void clean() {
        this.parsedWsdlFiles = new HashMap<URI, ServiceDefinition>();
        this.bundles = new HashSet<String>();
    }

    public void removeParsedFile(@NotNull URI location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/xmlparser/ParserContext.removeParsedFile must not be null");
        }
        this.parsedWsdlFiles.remove(location);
    }
}

