/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.xmlparser;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Element;
import oracle.bpm.project.catalog.parser.xmlparser.ElementFactory;
import oracle.bpm.project.catalog.parser.xmlparser.NamespaceContext;
import oracle.bpm.project.catalog.parser.xmlparser.Parser;
import oracle.bpm.project.catalog.parser.xmlparser.Text;
import org.xml.sax.Locator;

public class DefaultFactory
implements ElementFactory {
    private NamespaceContext context;
    private Locator locator;
    private Parser parser;

    @Override
    public void setContext(NamespaceContext ctx) {
        this.context = ctx;
    }

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Element create(String namespace, String name, Map<QName, String> attrs) {
        DefaultElement element = new DefaultElement();
        this.init(namespace, name, attrs, element);
        return element;
    }

    @Override
    public Element createText(String text) {
        return new Text(text);
    }

    protected void init(String namespace, String name, Map<QName, String> attrs, DefaultElement element) {
        if (this.locator == null && this.parser != null) {
            this.locator = this.parser.getLocator();
        }
        element.setTagName(name);
        element.setNamespace(namespace);
        element.setAttributes(attrs);
        element.setXMLParser(this.parser);
        element.setNSContext(this.context);
        if (this.locator != null) {
            element.setLine(this.locator.getLineNumber());
            element.setColumn(this.locator.getColumnNumber());
        }
    }
}

