/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmobject.XmlUtils;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Binding;
import oracle.bpm.project.catalog.parser.wsdl.Import;
import oracle.bpm.project.catalog.parser.wsdl.Message;
import oracle.bpm.project.catalog.parser.wsdl.PortDefinition;
import oracle.bpm.project.catalog.parser.wsdl.TypeDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xmlparser.ParserContext;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceDefinition
extends WsdlElement {
    private List<Binding> bindings;
    private Map<ObjectTypeDescription, WsdlElement> compiledServices;
    private List<XmlTypeDescription> faults;
    private List<Import> imports;
    private URL location;
    private List<String> locations = new ArrayList<String>();
    private List<Message> messages;
    private ParserContext parserContext;
    private List<PortDefinition> ports;
    private ServiceDefinitionContext serviceDefinitionContext = new ServiceDefinitionContext();
    private TypeDefinition type;

    ServiceDefinition() {
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getWsdl() {
        return this.getWsdl(null);
    }

    public void declareFaults(@NotNull XmlTypeDescription exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.declareFaults must not be null");
        }
        if (this.faults == null) {
            this.faults = new ArrayList<XmlTypeDescription>();
        }
        this.faults.add(exception);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<XmlTypeDescription> getFaults() {
        if (this.faults == null) {
            this.faults = new ArrayList<XmlTypeDescription>();
        }
        List<XmlTypeDescription> list = this.faults;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.getFaults must not return null");
        }
        return list;
    }

    public String getWsdl(@Nullable String[] processingInstructions) {
        StringWriter writer = new StringWriter();
        IndentedPrintWriter out = new IndentedPrintWriter(writer);
        this.dump(out, processingInstructions, "UTF-8");
        out.flush();
        out.close();
        return writer.getBuffer().toString();
    }

    public List<Binding> getBindings() {
        if (this.bindings == null) {
            this.bindings = this.findChildrenByClass(Binding.class);
        }
        return this.bindings;
    }

    public String getTargetNamespace() {
        return this.getAttribute("targetNamespace");
    }

    public TypeDefinition getTypeDef() {
        if (this.type == null) {
            this.type = this.findChildByClass(TypeDefinition.class);
        }
        return this.type;
    }

    public List<Import> getImports() {
        if (this.imports == null) {
            this.imports = this.findChildrenByClass(Import.class);
        }
        return this.imports;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setParserContext(@NotNull ParserContext parserContext) {
        if (parserContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.setParserContext must not be null");
        }
        this.parserContext = parserContext;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        for (Import anImport : this.getImports()) {
            anImport.verify();
        }
        TypeDefinition typeDefinition = this.getTypeDef();
        if (typeDefinition != null) {
            typeDefinition.verify();
        }
        for (Message message : this.getMessages()) {
            message.verify();
        }
        for (PortDefinition portDefinition : this.getPortDefinitions()) {
            portDefinition.verify();
        }
        for (Binding binding : this.getBindings()) {
            binding.verify();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<ObjectTypeDescription, WsdlElement> buildTypesFromPortTypes(@NotNull ParserContext parserContext) throws TypeBuildException {
        Map<ObjectTypeDescription, WsdlElement> map;
        if (parserContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.buildTypesFromPortTypes must not be null");
        }
        if (this.compiledServices != null) {
            map = this.compiledServices;
            if (map == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.buildTypesFromPortTypes must not return null");
            return map;
        }
        Context ctx = this.getContext();
        String target = this.getTargetNamespace();
        if (target != null && ctx.getTarget() == null) {
            ctx.setTarget(target);
        }
        this.parserContext = parserContext;
        this.locations.add(this.location.getFile());
        List<Import> imports = this.getImports();
        String defaultNamespace = this.getAttribute("xmlns");
        if (Str.isEmpty(defaultNamespace)) {
            this.getContext().addNamespace("", "");
        }
        for (Import anImport : imports) {
            this.resolverWsdlImport(anImport, this.serviceDefinitionContext, parserContext);
        }
        for (TypeDefinition type : this.serviceDefinitionContext.getTypes()) {
            for (ExtendedNamespace namespace : type.getTargets()) {
                this.getContext().updateNamespace(namespace);
            }
        }
        this.resolveSchema(this.getTypeDef());
        List<Message> messagesToBuild = this.serviceDefinitionContext.getMessages();
        messagesToBuild.addAll(this.getMessages());
        for (Message message : messagesToBuild) {
            message.buildArguments();
        }
        ArrayList<PortDefinition> portsToBuild = new ArrayList<PortDefinition>();
        portsToBuild.addAll(this.serviceDefinitionContext.getPorts());
        portsToBuild.addAll(this.getPortDefinitions());
        for (PortDefinition port : portsToBuild) {
            port.buildPort();
        }
        HashMap<ObjectTypeDescription, WsdlElement> result = new HashMap<ObjectTypeDescription, WsdlElement>();
        for (PortDefinition port : portsToBuild) {
            result.put((ObjectTypeDescription)port.getType(), port);
        }
        this.compiledServices = result;
        map = result;
        if (map != null) return map;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.buildTypesFromPortTypes must not return null");
    }

    public List<PortDefinition> getPortDefinitions() {
        if (this.ports == null) {
            this.ports = this.findChildrenByClass(PortDefinition.class);
        }
        return this.ports;
    }

    void setLocation(URL loc) {
        this.location = loc;
    }

    Message getMessage(String qname) {
        Message message = null;
        String prefix = this.prefix(qname);
        Namespace namespace = this.getContext().findNamespace(prefix);
        if (namespace != null) {
            if (namespace.getUri().equals(this.getTargetNamespace())) {
                List<Message> messages = this.getAllMessages();
                message = this.findByAttributeValue(messages, "name", this.localname(qname));
            } else {
                message = this.serviceDefinitionContext.findMessage(qname);
            }
        }
        return message;
    }

    private List<Message> getMessages() {
        if (this.messages == null) {
            this.messages = this.findChildrenByClass(Message.class);
        }
        return this.messages;
    }

    private List<Message> getAllMessages() {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(this.getMessages());
        messages.addAll(this.serviceDefinitionContext.getMessages());
        return messages;
    }

    private ServiceDefinitionContext getServiceDefinitionContext() {
        return this.serviceDefinitionContext;
    }

    private void resolveSchema(@Nullable TypeDefinition typeDef) throws TypeBuildException {
        if (typeDef != null) {
            typeDef.buildTypes();
        }
    }

    @Nullable
    private ServiceDefinition findAlreadyParsedDefinition(Import anImport) {
        ServiceDefinition importedServiceDefinition = null;
        try {
            String importLocation = anImport.getLocation();
            URL urlLocation = this.getServiceDefinition().getLocation();
            URL url = new URL(urlLocation, importLocation);
            importedServiceDefinition = this.getParserContext().getServiceDefinition(url.toURI());
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return importedServiceDefinition;
    }

    private void resolverWsdlImport(@NotNull Import anImport, @NotNull ServiceDefinitionContext context, @NotNull ParserContext parserContext) throws TypeBuildException {
        if (anImport == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.resolverWsdlImport must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.resolverWsdlImport must not be null");
        }
        if (parserContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/ServiceDefinition.resolverWsdlImport must not be null");
        }
        ServiceDefinition definition = this.findAlreadyParsedDefinition(anImport);
        if (definition == null) {
            definition = anImport.build();
        }
        if (definition != null) {
            definition.setParserContext(parserContext);
            String location = definition.getLocation().getFile();
            if (!this.locations.contains(location)) {
                this.locations.add(location);
                context.addFrom(definition);
                TypeDefinition typeDef = definition.getTypeDef();
                this.resolveSchema(typeDef);
                if (definition.getImports() != null) {
                    for (Import newImport : definition.getImports()) {
                        this.resolverWsdlImport(newImport, definition.getServiceDefinitionContext(), parserContext);
                    }
                }
                context.addFrom(definition.getServiceDefinitionContext());
            } else {
                this.reportWarning(ProjectCatalogMsg.WSDL_ALREADY_IMPORTED(location).toString());
            }
        }
    }

    static class ServiceDefinitionContext {
        final List<Message> messages = new ArrayList<Message>();
        final List<PortDefinition> ports = new ArrayList<PortDefinition>();
        final List<TypeDefinition> types = new ArrayList<TypeDefinition>();

        ServiceDefinitionContext() {
        }

        public List<TypeDefinition> getTypes() {
            return this.types;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<PortDefinition> getPorts() {
            return this.ports;
        }

        public void addFrom(ServiceDefinitionContext context) {
            this.getTypes().addAll(context.getTypes());
            this.getMessages().addAll(context.getMessages());
            this.getPorts().addAll(context.getPorts());
        }

        public void addFrom(ServiceDefinition serviceDef) {
            if (serviceDef.getTypeDef() != null) {
                this.getTypes().add(serviceDef.getTypeDef());
            }
            this.getMessages().addAll(serviceDef.getMessages());
            this.getPorts().addAll(serviceDef.getPortDefinitions());
        }

        public Message findMessage(String qname) {
            Message msg = null;
            String msgName = XmlUtils.localname((String)qname);
            List<Message> messages = this.getMessages();
            for (Message message : messages) {
                if (!message.getName().equals(msgName)) continue;
                msg = message;
                break;
            }
            return msg;
        }
    }
}

