/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.Documentation;
import oracle.bpm.project.catalog.parser.wsdl.Fault;
import oracle.bpm.project.catalog.parser.wsdl.Input;
import oracle.bpm.project.catalog.parser.wsdl.OperationType;
import oracle.bpm.project.catalog.parser.wsdl.Output;
import oracle.bpm.project.catalog.parser.wsdl.Part;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.xmlparser.DefaultElement;
import oracle.bpm.project.catalog.parser.xmlparser.Namespace;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class Operation
extends WsdlElement {
    private List<Fault> faults;
    private Input input;
    private MethodTypeDescription method;
    private OperationType opType = null;
    private Output output;

    Operation() {
        this.setTagName("operation");
    }

    Operation(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public Input getInput() {
        if (this.input == null) {
            this.input = (Input)this.findChildByName("input");
        }
        return this.input;
    }

    public Output getOutput() {
        if (this.output == null) {
            this.output = (Output)this.findChildByName("output");
        }
        return this.output;
    }

    public OperationType getType() {
        if (this.opType == null) {
            DefaultElement next;
            DefaultElement first = this.getFirstElement();
            DefaultElement defaultElement = next = first != null ? first.getNextElement() : null;
            this.opType = first instanceof Input && next == null ? OperationType.ONE_WAY : (first instanceof Output && next == null ? OperationType.NOTIFICATION : (first instanceof Input && next instanceof Output ? OperationType.REQUEST_RESPONSE : OperationType.SOLICIT_RESPONSE));
        }
        return this.opType;
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        Output out;
        String name = this.getName();
        if (name == null) {
            URL location = this.getServiceDefinition().getLocation();
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("name", "operation"));
        }
        Input in = this.getInput();
        if (in != null) {
            in.verify();
        }
        if ((out = this.getOutput()) != null) {
            out.verify();
        }
        for (Fault fault : this.getFaults()) {
            fault.verify();
        }
    }

    public List<Fault> getFaults() {
        if (this.faults == null) {
            this.faults = this.findChildrenByClass(Fault.class);
        }
        return this.faults;
    }

    MethodTypeDescription getMethod() {
        return this.method;
    }

    void setName(String name) {
        this.setAttribute("name", name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    MethodTypeDescription buildMethod() throws TypeBuildException {
        List<Argument> args;
        MethodTypeDescription methodTypeDescription;
        if (this.method != null) {
            methodTypeDescription = this.method;
            if (methodTypeDescription == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Operation.buildMethod must not return null");
            return methodTypeDescription;
        }
        String name = this.getName();
        this.method = new MethodTypeDescription(Identifier.method(name));
        this.method.setSignature(this.method.getName());
        this.method.setProperty("nativeName", name);
        Documentation doc = this.getDocumentation();
        if (doc != null) {
            this.method.setDescription(doc.getText());
        }
        HashMap<String, Argument> inArgs = new HashMap<String, Argument>();
        Input input = this.getInput();
        Output output = this.getOutput();
        if (input != null) {
            args = input.buildArguments();
            for (Argument arg : args) {
                this.method.addArgument(arg);
                inArgs.put(arg.getName(), arg);
            }
            this.method.setProperty("inputMessage", this.localname(input.getMessage()));
            this.method.setProperty("inputMessageNamespace", this.findNamespaceUri(input.getMessage()));
        }
        if (output != null) {
            args = output.buildArguments(this);
            for (Argument arg : args) {
                String argName = arg.getName();
                if (inArgs.containsKey(argName)) {
                    arg.setName(argName + "Output");
                }
                this.method.addArgument(arg);
            }
            List<Part> parts = output.getMsg().getParts();
            for (Part part : parts) {
                String elementName = part.getAttribute("element");
                if (elementName == null) continue;
                String prefix = this.prefix(elementName);
                Context partContext = part.getContext();
                String responseNamespace = "";
                if (prefix != null) {
                    Namespace reponseElementNamespace = partContext.findNamespace(prefix);
                    responseNamespace = reponseElementNamespace.getUri();
                }
                this.method.setProperty("messageResponseNamespace", responseNamespace);
                this.method.setProperty("soapOperationResponse", this.localname(elementName));
            }
            this.method.setProperty("outputMessage", this.localname(output.getMessage()));
            this.method.setProperty("outputMessageNamespace", this.findNamespaceUri(output.getMessage()));
        }
        this.method.setProperty("mep", this.getType().toString());
        List<Fault> faults = this.getFaults();
        for (Fault fault : faults) {
            XmlTypeDescription exception = fault.buildException();
            this.method.addException((TypeRef)exception);
            this.getServiceDefinition().declareFaults(exception);
        }
        methodTypeDescription = this.method;
        if (methodTypeDescription != null) return methodTypeDescription;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Operation.buildMethod must not return null");
    }
}

