/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.catalog.parser.wsdl.ServiceDefinition;
import oracle.bpm.project.catalog.parser.wsdl.WsdlElement;
import oracle.bpm.project.catalog.parser.wsdl.WsdlParser;
import oracle.bpm.project.catalog.parser.wsdl.exception.ImportParseException;
import oracle.bpm.project.catalog.parser.wsdl.exception.WsdlTypeBuildException;
import oracle.bpm.project.catalog.parser.xmlparser.NoWellFormedContentException;
import oracle.bpm.project.catalog.parser.xsd.Context;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.xmltype.EntityResolver;
import oracle.bpm.project.catalog.xmltype.ImportType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Import
extends WsdlElement {
    public Import() {
        this.setTagName("import");
    }

    public String getLocation() {
        return this.getAttribute("location");
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public void setImportedNamespace(String importNamespace) {
        this.setAttribute("namespace", importNamespace);
    }

    public String getImportedNamespace() {
        return this.getAttribute("namespace");
    }

    @Override
    public void verify() throws NoWellFormedContentException {
        URL location = this.getServiceDefinition().getLocation();
        if (this.getNamespace() == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("namespace", "import"));
        }
        if (this.getLocation() == null) {
            throw new NoWellFormedContentException(location, ProjectCatalogMsg.MISSING_ATTRIBUTE("location", "import"));
        }
    }

    @Nullable
    public ServiceDefinition build() throws TypeBuildException {
        ServiceDefinition result;
        block10: {
            result = null;
            String namespace = this.getNS();
            String location = this.getLocation();
            WsdlParser wsdlParser = this.getWSDLParser();
            EntityResolver resolver = wsdlParser.getXsdImportResolver();
            URL urlLocation = this.getServiceDefinition().getLocation();
            try {
                URL url = URLHelper.resolveURL((URL)urlLocation, (String)location);
                String file = url.getFile();
                if (resolver != null) {
                    if (this.isSchemaImport(file)) {
                        SchemaParser schemaParser = new SchemaParser(wsdlParser.getFileSystem(), wsdlParser.getTypeFinder());
                        InputStream reader = resolver.resolveEntity(urlLocation, location, namespace, ImportType.IMPORT_TYPE_XSD10);
                        Context context = this.getContext();
                        try {
                            schemaParser.importSchema(context, url, reader);
                            break block10;
                        }
                        catch (TypeParseException e) {
                            throw new ImportParseException(this, e);
                        }
                    }
                    result = wsdlParser.getParserContext().getServiceDefinition(this.urlToUri(url));
                    if (result == null) {
                        InputStream inputStream = resolver.resolveEntity(urlLocation, location, namespace, ImportType.IMPORT_TYPE_WSDL11);
                        if (inputStream == null) {
                            inputStream = url.openStream();
                        }
                        result = this.resolveWsdlImport(url, inputStream);
                        wsdlParser.getParserContext().addParsedWsdlFile(this.urlToUri(url), result);
                    }
                    break block10;
                }
                if (!this.isSchemaImport(file) && (result = wsdlParser.getParserContext().getServiceDefinition(this.urlToUri(url))) == null) {
                    InputStream inputStream = url.openStream();
                    result = this.resolveWsdlImport(url, inputStream);
                    wsdlParser.getParserContext().addParsedWsdlFile(this.urlToUri(url), result);
                }
            }
            catch (IOException e) {
                throw new ImportParseException(this, e);
            }
            catch (TypeParseException e) {
                throw new ImportParseException(this, e);
            }
        }
        return result;
    }

    public String getNS() {
        return this.getAttribute("namespace");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private URI urlToUri(@NotNull URL url) throws WsdlTypeBuildException {
        URI uRI;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Import.urlToUri must not be null");
        }
        try {
            uRI = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ImportParseException(this, e);
        }
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Import.urlToUri must not return null");
        }
        return uRI;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private ServiceDefinition resolveWsdlImport(@NotNull URL url, @NotNull InputStream inputStream) throws TypeParseException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Import.resolveWsdlImport must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/parser/wsdl/Import.resolveWsdlImport must not be null");
        }
        WsdlParser parser = this.getWSDLParser();
        ServiceDefinition serviceDefinition = parser.parseDefinition(url, inputStream);
        String targetNamespace = serviceDefinition.getTargetNamespace();
        serviceDefinition.getContext().setTarget(targetNamespace);
        ServiceDefinition serviceDefinition2 = serviceDefinition;
        if (serviceDefinition2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/parser/wsdl/Import.resolveWsdlImport must not return null");
        }
        return serviceDefinition2;
    }

    private boolean isSchemaImport(String file) {
        return file != null && file.endsWith("xsd");
    }
}

