/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.parser.wsdl;

import java.util.Arrays;

class HttpElementType {
    static final int ADDRESS = 0;
    static final int BINDING = 1;
    static final int OPERATION = 2;
    static final int URL_ENCODED = 3;
    static final int URL_REPLACEMENT = 4;
    private static String[] names = new String[5];

    HttpElementType() {
    }

    static int findByName(String name) {
        return Arrays.binarySearch(names, name);
    }

    static String findByType(int type) {
        return type > 0 && type < names.length ? names[type] : null;
    }

    static {
        HttpElementType.names[0] = "address";
        HttpElementType.names[1] = "binding";
        HttpElementType.names[2] = "operation";
        HttpElementType.names[3] = "urlEncoded";
        HttpElementType.names[4] = "urlReplacement";
        for (int i = 1; i < names.length; ++i) {
            if (names[i - 1].compareTo(names[i]) <= 1) continue;
            throw new RuntimeException("Names must be sorted by name");
        }
    }
}

