/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.msg;

import javax.xml.namespace.QName;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCatalogMsg
extends MsgBundle {
    public static TMsg WSDL_ALREADY_IMPORTED = ProjectCatalogMsg.tmsg("URL '%0' was already imported");
    public static TMsg CANNOT_FIND_DECL = ProjectCatalogMsg.tmsg("Cannot find namespace declaration for prefix '%0'");
    public static TMsg IMPORT_COULD_NOT_BE_PARSED = ProjectCatalogMsg.tmsg("Resource could not be parsed: '%0'.");
    public static TMsg ELEMENT_COULD_NOT_BE_RESOLVED = ProjectCatalogMsg.tmsg("Element '%0' could not be found.");
    public static TMsg ENCODING_NOT_SUPPORTED = ProjectCatalogMsg.tmsg("Encoding '%0' is not supported.");
    public static TMsg MISSING_ATTRIBUTE = ProjectCatalogMsg.tmsg("Missing attribute '%0' for tag '%1'.");
    private static final TMsg UNSUPPORTED_SERVICE_TYPE = ProjectCatalogMsg.tmsg("Unsupported service type. Service: '%0' of type: '%1'.");
    private static final TErrorMsg MISSING_BPMO_SCRIPT = ProjectCatalogMsg.tErrorMsg("Missing script for operation '%1'.", "The %(BPM_OBJECT) '%0' cannot be correctly loaded because operation '%0' has not script", "Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TMsg MISSING_SERVICE = ProjectCatalogMsg.tmsg("Service '%0' cannot be found.");
    private static final TMsg UNSUPPORTED_TYPE = ProjectCatalogMsg.tmsg("Unsupported type: '%0'");
    public static TMsg MESSAGE_NOT_FOUND = ProjectCatalogMsg.tmsg("Wsdl message '%0' for operation '%1' not found.");
    public static TMsg OP_OVERLOADED = ProjectCatalogMsg.tmsg("Operation '%0' is overloaded. Operation name overloading in a wsdl:portType is not WS-I compliant. ");
    public static Msg WSDL_BUILDER_ERROR = ProjectCatalogMsg.msg("Wsdl could not be generated");
    private static final TErrorMsg INVALID_BPMO_NAMESPACE = ProjectCatalogMsg.tErrorMsg("Invalid %(BPM_OBJECT) Namespace: %0", "The %(BPM_OBJECT) namespace '%0' does not exists in context", "Please verify that the %(BPM_OBJECT) wsdl and xsd are valid");
    private static final TErrorMsg DELEGATED_SERVICE_NOT_FOUND = ProjectCatalogMsg.tErrorMsg("Unable to load operation '%0'", "The service definition '%1' does not exist in this project or it is corrupted", "Please verify that the definition exists in the composite and is valid");
    private static final TErrorMsg MISSING_BPMO_SCHEMA = ProjectCatalogMsg.tErrorMsg("Unable to load %(BPM_OBJECT) '%1'", "The element or type '%0' represented by %(BPM_OBJECT) does not exist in this project or it is corrupted", "Please verify that the schema exists and is valid");
    private static final TErrorMsg UNEXPECTED_PARSER_ERROR = ProjectCatalogMsg.tErrorMsg("Unexpected error parsing '%0'", "%1", "Verify that file is valid and accessible");
    private static final TErrorMsg UNEXPECTED_TYPEBUILD_ERROR = ProjectCatalogMsg.tErrorMsg("Unexpected error build types for '%0'", "%1", "Verify that file is valid and accessible");
    private static final TErrorMsg INVALID_BPMO_FORMAT = ProjectCatalogMsg.tErrorMsg("Unable to load %(BPM_OBJECT) '%0'", "The %(BPM_OBJECT) format is invalid or it is corrupted", "Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TErrorMsg INVALID_BPMO_OPERATION = ProjectCatalogMsg.tErrorMsg("Unable to load %(BPM_OBJECT)", "The '%0' operation is invalid", "Please verify that the %(BPM_OBJECT) wsdl has a valid format");
    private static final TErrorMsg MISSING_DELEGATED_OPERATION = ProjectCatalogMsg.tErrorMsg("Unable to load operation '%0'", "Unable to find an operation named '%1' on the delegated service", "Please check that the delegated operation exists on the service.");
    private static final TErrorMsg MISSING_OPERATION = ProjectCatalogMsg.tErrorMsg("Unable to load operation '%0'", "Cannot find binding for operation named '%0' on the delegated service", "Please check that the delegated operation exists on the service.");
    private static final TErrorMsg MISSING_BPMO_BINDING = ProjectCatalogMsg.tErrorMsg("Unable to load %(BPM_OBJECT) '%0'", "Cannot find binding in %(BPM_OBJECT)", "The %(BPM_OBJECT) is invalid. It must be regenerated");
    private static final TErrorMsg MISSING_BPMO_PORT = ProjectCatalogMsg.tErrorMsg("Unable to load %(BPM_OBJECT) '%0'", "Cannot find port in %(BPM_OBJECT)", "The %(BPM_OBJECT) is invalid. It must be regenerated");
    private static final TErrorMsg MISSING_DELEGATED_OPERATION_NAME = ProjectCatalogMsg.tErrorMsg("Cannot find right name to the operation in %(BPM_OBJECT) %0", "Unable to find the operation's right name on the delegated service", "Please check that the delegated operation exists on the service.");
    private static final TErrorMsg NONMATCHING_DUPLICATED_SCHEMA = ProjectCatalogMsg.tErrorMsg("Unable to load resource '%0' referenced by '%1'", "Resource cannot be loaded because an element/type with qname '%2' already exists in '%3' and they differ", "Please check the resources for duplicated elements/types.");
    private static final TErrorMsg DUPLICATED_PORTTYPE = ProjectCatalogMsg.tErrorMsg("Unable to load resource '%0'", "Resource cannot be loaded because a portType with qname '%1' already exists in '%2'", "Please check the resources for duplicated portTypes.");
    private static final TErrorMsg CANNOT_PARSE_BUINESS_RULE = ProjectCatalogMsg.tErrorMsg("Unable to parse business rule '%0'", "%1", "Please check that the business rule is valid.");
    private static final TErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT = ProjectCatalogMsg.tErrorMsg("Unable to build types for business rule '%0'", "The argument '%2' of decision function '%1' could not be build becasue of '%3'.", "Please check the XML-Schema of the function arguments.");
    private static final TErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME = ProjectCatalogMsg.tErrorMsg("Unable to identify the parameter QName", "'%0'", "Make sure that the decision function parameter is of XML type and exactly one XML Schema Element exists that represents the parameter");
    private static final TErrorMsg CANNOT_PARSE_EVENT_DEFINITION = ProjectCatalogMsg.tErrorMsg("Unable to parse event definition '%0'", "%1", "Please check that the event definition is valid.");
    private static final TErrorMsg CANNOT_PARSE_COMPOSITE = ProjectCatalogMsg.tErrorMsg("Unable to parse the composite", "%0", "Please check that the composite is valid.");
    private static final TErrorMsg CANNOT_PARSE_HUMANTASK = ProjectCatalogMsg.tErrorMsg("Unable to parse the human task '%0'", "%1", "Please check that the human task is valid.");
    private static final TErrorMsg DUPLICATED_TYPENAME = ProjectCatalogMsg.tErrorMsg("Unable to load resource '%0'", "Resource cannot be loaded because an object with name '%1' already exists and was created by '%2'", "Please check the resources for duplicates.");
    private static final TErrorMsg NONMATCHING_ARGS_DELEGATED_OPERATION = ProjectCatalogMsg.tErrorMsg("Unable to load operation '%0'", "The operation arguments do not match with delegated operation '%1' on the delegated service", "Please check if the arguments have changed");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_TARGET = ProjectCatalogMsg.tErrorMsg("Customized service '%0' has not a Service target property", "Customized service wsdl is invalid", "Recreate the customized service");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_PORT = ProjectCatalogMsg.tErrorMsg("Customized service '%0' has not a Port Type property", "Customized service wsdl is invalid", "Recreate the customized service");
    private static final TErrorMsg DELEGATED_SERVICE_WITHOUT_NAMESPACE = ProjectCatalogMsg.tErrorMsg("Customized service '%0' has not a Namespace property", "Customized service wsdl is invalid", "Recreate the customized service");
    private static final TMsg CANNOT_FIND_VFILE = ProjectCatalogMsg.tmsg("Cannot find vfile for: '%0'.");
    private static final TMsg ERROR_UPDATING_COMPOSITE = ProjectCatalogMsg.tmsg("Unexpected error updating composite for process '%0'.\nReason:\n%1\nCall Trace:\n%2");
    private static final TMsg MALFORMED_URI = ProjectCatalogMsg.tmsg("Invalid URI '%0'");
    private static final TMsg MISSINGTYPEEXCEPTION = ProjectCatalogMsg.tmsg("Invalid type '%0' with id '%1'");
    private static final TMsg ATTR_GROUP_NOT_FOUND = ProjectCatalogMsg.tmsg("Attribute group '%0' not found at '%1'.");
    private static final TMsg ATTR_NOT_FOUND = ProjectCatalogMsg.tmsg("Attribute '%0' not found at '%1'.");
    private static final TMsg ELEM_NOT_FOUND = ProjectCatalogMsg.tmsg("Element '%0' not found at '%1'.");
    private static final TMsg GROUP_NOT_FOUND = ProjectCatalogMsg.tmsg("Group '%0' not found at '%1'.");
    private static final TMsg INV_ATTR_VALUE = ProjectCatalogMsg.tmsg("Invalid value: '%0' for attribute '%1' of element '%2'.");
    private static final TMsg INV_LOCAL_NAME = ProjectCatalogMsg.tmsg("Name '%0' is not a valid local name.");
    private static final TMsg INV_ROOT = ProjectCatalogMsg.tmsg("The specified XML is not a valid XML schema. The root element must be <schema> and not '%0'.'");
    private static final TMsg NS_NOT_DECL = ProjectCatalogMsg.tmsg("The namespace for prefix '%0' is not declared.");
    private static final TMsg TYPE_NOT_FOUND = ProjectCatalogMsg.tmsg("Type '%0' not found in namespace '%1'.");
    private static final TErrorMsg SERVICE_NOT_FOUND = ProjectCatalogMsg.tErrorMsg("Type '%0', the composite.xml has an invalid service reference", "The specified service was not found in the composite.xml", "Verify that all services references are correct");
    private static final TMsg ERROR = ProjectCatalogMsg.tmsg("Error: '%0'");
    private static final TMsg WARNING = ProjectCatalogMsg.tmsg("Warning: '%0'");
    private static final TMsg SOAP_ENCODING_ARRAY_WARNING = ProjectCatalogMsg.tmsg("It is not recommended the usage of SOAP encoding array types, specially if you are working with document/literal WSDLs (complex type name: %0 in namespace: %1 )");
    public static Msg MISSING_NAME_OR_REF = ProjectCatalogMsg.msg("Missing the 'name' or 'ref' attribute.");
    private static final TMsg INVALID_SCHEMA_ELEMENT = ProjectCatalogMsg.tmsg("Invalid schema element '%0'");
    public static TErrorMsg CORRUPTED_CONTENT_MALFORMED_RESOURCE = ProjectCatalogMsg.tErrorMsg("Resource file '%0' could not be parsed", "%1", "Fix the Resource to continue");
    public static Msg SEQUENCE_WITH_RESTRICTION_NOT_SUPPORTED = ProjectCatalogMsg.msg("The sequence structure with maxOccurs or minOccurs is not supported.");
    private static final TMsg INVALID_LOCATION = ProjectCatalogMsg.tmsg("Invalid location: '%0' ");
    public static Msg ERROR_LOADING_COMPOSITE_DATA = ProjectCatalogMsg.msg("Error loading composite data.");
    private static final TMsg CANNOT_LOAD_JDEV_PROJECT = ProjectCatalogMsg.tmsg("Cannot load Jdev project for BPM Project: '%0'");
    private static final TErrorMsg WSDL_RESOURCE_COULD_NOT_BE_LOADED = ProjectCatalogMsg.tErrorMsg("WSDL '%0' could not be loaded due to an error parsing the XML tag '%1' defined at line '%2'", "%3", "Fix the WSDL to continue");
    private static final TErrorMsg XSD_RESOURCE_COULD_NOT_BE_LOADED = ProjectCatalogMsg.tErrorMsg("Xml Schema '%0' could not be loaded due to an error parsing the XML tag '%1' defined at line '%2'", "%3", "Fix the Xml Schema to continue");
    private static final TErrorMsg UNEXPECTED_IO_ERROR = ProjectCatalogMsg.tErrorMsg("Unexpected error when loading resource '%0'", "The specified resource could not be loaded", "Check logs for more detail");
    private static final TErrorMsg FAULT_WITHOUT_ERRORINFO = ProjectCatalogMsg.tErrorMsg("The Exception '%0' doesn't have the errorInfo attribute", "The specified exception is not valid", "Check the attribute of the exception and add the only errorInfo attribute");
    public static TErrorMsg RESOURCE_COULD_NOT_BE_PARSED = ProjectCatalogMsg.tErrorMsg("Resource '%0' could not be parsed.", "%1", "Check the logs for more details");
    private static final TErrorMsg FAULT_INVALID_CONTENT = ProjectCatalogMsg.tErrorMsg("The Exception '%0' has more than one attribute", "The specified exception is not valid", "Check the attribute of the exception and add only the errorInfo attribute");
    public static final Msg XML_ELEMENT = ProjectCatalogMsg.msg("XML Schema Element", "", "xml_element_16X16.png");
    public static final Msg XML_COMPLEX_TYPE = ProjectCatalogMsg.msg("XML Schema Complex Type", "", "xml_complexType_16X16.png");
    public static final Msg XML_ENUM = ProjectCatalogMsg.msg("XML Schema Enumeration", "", "xml_enumeration_16X16.png");
    public static final Msg XML = ProjectCatalogMsg.msg("XML Schema", "", "xml_element_16X16.png");
    public static final Msg EVENT = ProjectCatalogMsg.msg("Event", "", "event_16X16.png");
    public static final Msg CORRUPTED_RESOURCE = ProjectCatalogMsg.msg("Corrupted Resource", "", "corrupted_resource_16X16.gif");

    public static ErrorMsg INVALID_BPMO_NAMESPACE(String _arg0) {
        return INVALID_BPMO_NAMESPACE.args(_arg0);
    }

    public static ErrorMsg DELEGATED_SERVICE_NOT_FOUND(String _arg0, String _arg1) {
        return DELEGATED_SERVICE_NOT_FOUND.args(_arg0, _arg1);
    }

    public static ErrorMsg MISSING_BPMO_SCHEMA(QName _arg0, String _arg1) {
        return MISSING_BPMO_SCHEMA.args(_arg0, _arg1);
    }

    public static ErrorMsg UNEXPECTED_PARSER_ERROR(String uri, String cause) {
        return UNEXPECTED_PARSER_ERROR.args(uri, cause);
    }

    public static ErrorMsg UNEXPECTED_TYPEBUILD_ERROR(String uri, String cause) {
        return UNEXPECTED_TYPEBUILD_ERROR.args(uri, cause);
    }

    public static ErrorMsg INVALID_BPMO_FORMAT(String name) {
        return INVALID_BPMO_FORMAT.args(name);
    }

    public static ErrorMsg INVALID_BPMO_OPERATION(String operationName) {
        return INVALID_BPMO_OPERATION.args(operationName);
    }

    public static ErrorMsg NONMATCHING_DUPLICATED_SCHEMA(@NotNull String failedResourceUri, @NotNull String failedResourceDep, @NotNull QName qName, @Nullable String originPath) {
        if (failedResourceUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        if (failedResourceDep == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.NONMATCHING_DUPLICATED_SCHEMA must not be null");
        }
        return NONMATCHING_DUPLICATED_SCHEMA.args(failedResourceUri, failedResourceDep, qName, originPath);
    }

    public static ErrorMsg DUPLICATED_PORTTYPE(String _arg0, QName _arg1, String _arg2) {
        return DUPLICATED_PORTTYPE.args(_arg0, _arg1, _arg2);
    }

    public static ErrorMsg CANNOT_PARSE_BUINESS_RULE(String uri, String cause) {
        return CANNOT_PARSE_BUINESS_RULE.args(uri, cause);
    }

    public static ErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT(String uri, String funcName, String argName, String sdkMsg) {
        return CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT.args(uri, funcName, argName, sdkMsg);
    }

    public static ErrorMsg CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME(String arg) {
        return CANNOT_BUILD_DECISIONFUNCTION_ARGUMENT_QNAME.args(arg);
    }

    public static ErrorMsg CANNOT_PARSE_EVENT_DEFINITION(String uri, String cause) {
        return CANNOT_PARSE_EVENT_DEFINITION.args(uri, cause);
    }

    public static ErrorMsg CANNOT_PARSE_COMPOSITE(String cause) {
        return CANNOT_PARSE_COMPOSITE.args(cause);
    }

    public static ErrorMsg CANNOT_PARSE_HUMANTASK(String uri, String cause) {
        return CANNOT_PARSE_HUMANTASK.args(uri, cause);
    }

    public static ErrorMsg DUPLICATED_TYPENAME(String _arg0, String _arg1, String _arg2) {
        return DUPLICATED_TYPENAME.args(_arg0, _arg1, _arg2);
    }

    public static ErrorMsg MISSING_DELEGATED_OPERATION(String _arg0, String _arg1) {
        return MISSING_DELEGATED_OPERATION.args(_arg0, _arg1);
    }

    public static ErrorMsg MISSING_OPERATION(String operationName) {
        return MISSING_OPERATION.args(operationName);
    }

    public static ErrorMsg MISSING_BPMO_PORT(String bpmObjectName) {
        return MISSING_BPMO_PORT.args(bpmObjectName);
    }

    public static ErrorMsg MISSING_BPMO_BINDING(String bpmObjectName) {
        return MISSING_BPMO_BINDING.args(bpmObjectName);
    }

    public static ErrorMsg NONMATCHING_ARGS_DELEGATED_OPERATION(String _arg0, String _arg1) {
        return NONMATCHING_ARGS_DELEGATED_OPERATION.args(_arg0, _arg1);
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_TARGET(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_TARGET.args(bpmObject);
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_PORT(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_PORT.args(bpmObject);
    }

    public static ErrorMsg MISSING_DELEGATED_OPERATION_NAME(String bpmObject) {
        return MISSING_DELEGATED_OPERATION_NAME.args(bpmObject);
    }

    public static ErrorMsg DELEGATED_SERVICE_WITHOUT_NAMESPACE(String bpmObject) {
        return DELEGATED_SERVICE_WITHOUT_NAMESPACE.args(bpmObject);
    }

    public static Msg UNSUPPORTED_SERVICE_TYPE(String text, String componentType) {
        return UNSUPPORTED_SERVICE_TYPE.args(text, componentType);
    }

    public static ErrorMsg CORRUPTED_CONTENT_MALFORMED_RESOURCE(@NotNull String uri, @NotNull String cause) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.CORRUPTED_CONTENT_MALFORMED_RESOURCE must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/msg/ProjectCatalogMsg.CORRUPTED_CONTENT_MALFORMED_RESOURCE must not be null");
        }
        return CORRUPTED_CONTENT_MALFORMED_RESOURCE.args(uri, cause);
    }

    public static ErrorMsg WSDL_RESOURCE_COULD_NOT_BE_LOADED(String location, String tagname, int line, String cause) {
        return WSDL_RESOURCE_COULD_NOT_BE_LOADED.args(location, tagname, line, cause);
    }

    public static ErrorMsg XSD_RESOURCE_COULD_NOT_BE_LOADED(String location, String tagname, int line, String cause) {
        return XSD_RESOURCE_COULD_NOT_BE_LOADED.args(location, tagname, line, cause);
    }

    public static Msg CANNOT_FIND_VFILE(String uri) {
        return CANNOT_FIND_VFILE.args(uri);
    }

    public static ErrorMsg UNEXPECTED_IO_ERROR(String _arg0) {
        return UNEXPECTED_IO_ERROR.args(_arg0);
    }

    public static ErrorMsg FAULT_WITHOUT_ERRORINFO(String _arg0) {
        return FAULT_WITHOUT_ERRORINFO.args(_arg0);
    }

    public static ErrorMsg FAULT_INVALID_CONTENT(String _arg0) {
        return FAULT_INVALID_CONTENT.args(_arg0);
    }

    public static Msg MALFORMED_URI(String _arg0) {
        return MALFORMED_URI.args(_arg0);
    }

    public static Msg MISSINGTYPEEXCEPTION(String name, String typeId) {
        return MISSINGTYPEEXCEPTION.args(name, typeId);
    }

    public static Msg ATTR_GROUP_NOT_FOUND(String _arg0, String _arg1) {
        return ATTR_GROUP_NOT_FOUND.args(_arg0, _arg1);
    }

    public static Msg ATTR_NOT_FOUND(String _arg0, String _arg1) {
        return ATTR_NOT_FOUND.args(_arg0, _arg1);
    }

    public static Msg ELEM_NOT_FOUND(String _arg0, String _arg1) {
        return ELEM_NOT_FOUND.args(_arg0, _arg1);
    }

    public static Msg GROUP_NOT_FOUND(String _arg0, String _arg1) {
        return GROUP_NOT_FOUND.args(_arg0, _arg1);
    }

    public static Msg INV_ATTR_VALUE(String _arg0, String _arg1, String _arg2) {
        return INV_ATTR_VALUE.args(_arg0, _arg1, _arg2);
    }

    public static Msg INV_LOCAL_NAME(String _arg0) {
        return INV_LOCAL_NAME.args(_arg0);
    }

    public static Msg INV_ROOT(String _arg0) {
        return INV_ROOT.args(_arg0);
    }

    public static Msg NS_NOT_DECL(String _arg0) {
        return NS_NOT_DECL.args(_arg0);
    }

    public static Msg TYPE_NOT_FOUND(String name, String namespace) {
        return TYPE_NOT_FOUND.args(name, namespace);
    }

    public static ErrorMsg SERVICE_NOT_FOUND(String serviceName) {
        return SERVICE_NOT_FOUND.args(serviceName);
    }

    public static Msg ERROR_UPDATING_COMPOSITE(String process, String exception, String trace) {
        return ERROR_UPDATING_COMPOSITE.args(process, exception, trace);
    }

    public static Msg ERROR(String _arg0) {
        return ERROR.args(_arg0);
    }

    public static Msg WARNING(String _arg0) {
        return WARNING.args(_arg0);
    }

    public static Msg UNSUPPORTED_TYPE(TypeDescription _arg0) {
        return UNSUPPORTED_TYPE.args(_arg0);
    }

    public static Msg SOAP_ENCODING_ARRAY_WARNING(String _arg0, String _arg1) {
        return SOAP_ENCODING_ARRAY_WARNING.args(_arg0, _arg1);
    }

    public static Msg CANNOT_FIND_DECL(String _arg0) {
        return CANNOT_FIND_DECL.args(_arg0);
    }

    public static Msg ENCODING_NOT_SUPPORTED(String _arg0) {
        return ENCODING_NOT_SUPPORTED.args(_arg0);
    }

    public static Msg ELEMENT_COULD_NOT_BE_RESOLVED(String qname) {
        return ELEMENT_COULD_NOT_BE_RESOLVED.args(qname);
    }

    public static Msg IMPORT_COULD_NOT_BE_PARSED(String location) {
        return IMPORT_COULD_NOT_BE_PARSED.args(location);
    }

    public static ErrorMsg RESOURCE_COULD_NOT_BE_PARSED(String location, String cause) {
        return RESOURCE_COULD_NOT_BE_PARSED.args(location, cause);
    }

    public static Msg MISSING_ATTRIBUTE(String _arg0, String _arg1) {
        return MISSING_ATTRIBUTE.args(_arg0, _arg1);
    }

    public static Msg MISSING_SERVICE(String _arg0) {
        return MISSING_SERVICE.args(_arg0);
    }

    public static ErrorMsg MISSING_BPMO_SCRIPT(String name, String operation) {
        return MISSING_BPMO_SCRIPT.args(name, operation);
    }

    public static Msg MESSAGE_NOT_FOUND(String _arg0, String _arg1) {
        return MESSAGE_NOT_FOUND.args(_arg0, _arg1);
    }

    public static Msg OP_OVERLOADED(String _arg0) {
        return OP_OVERLOADED.args(_arg0);
    }

    public static Msg WSDL_ALREADY_IMPORTED(String _arg0) {
        return WSDL_ALREADY_IMPORTED.args(_arg0);
    }

    public static Msg INVALID_LOCATION(@Nullable String location) {
        return INVALID_LOCATION.args(location == null ? "" : location);
    }

    public static Msg INVALID_SCHEMA_ELEMENT(String tagName) {
        return INVALID_SCHEMA_ELEMENT.args(tagName);
    }

    public static Msg CANNOT_LOAD_JDEV_PROJECT(String projectName) {
        return CANNOT_LOAD_JDEV_PROJECT.args(projectName);
    }

    static {
        ProjectCatalogMsg.init(ProjectCatalogMsg.class, LogComponent.DEFAULT, ErrorRange.PROJECT_CATALOG);
    }
}

